% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_operations.R
\name{batch_list_jobs}
\alias{batch_list_jobs}
\title{Returns a list of Batch jobs}
\usage{
batch_list_jobs(
  jobQueue = NULL,
  arrayJobId = NULL,
  multiNodeJobId = NULL,
  jobStatus = NULL,
  maxResults = NULL,
  nextToken = NULL,
  filters = NULL
)
}
\arguments{
\item{jobQueue}{The name or full Amazon Resource Name (ARN) of the job queue used to
list jobs.}

\item{arrayJobId}{The job ID for an array job. Specifying an array job ID with this
parameter lists all child jobs from within the specified array.}

\item{multiNodeJobId}{The job ID for a multi-node parallel job. Specifying a multi-node
parallel job ID with this parameter lists all nodes that are associated
with the specified job.}

\item{jobStatus}{The job status used to filter jobs in the specified queue. If the
\code{filters} parameter is specified, the \code{jobStatus} parameter is ignored
and jobs with any status are returned. If you don't specify a status,
only \code{RUNNING} jobs are returned.}

\item{maxResults}{The maximum number of results returned by \code{\link[=batch_list_jobs]{list_jobs}}
in paginated output. When this parameter is used,
\code{\link[=batch_list_jobs]{list_jobs}} only returns \code{maxResults} results in a
single page and a \code{nextToken} response element. The remaining results of
the initial request can be seen by sending another
\code{\link[=batch_list_jobs]{list_jobs}} request with the returned \code{nextToken}
value. This value can be between 1 and 100. If this parameter isn't
used, then \code{\link[=batch_list_jobs]{list_jobs}} returns up to 100 results and
a \code{nextToken} value if applicable.}

\item{nextToken}{The \code{nextToken} value returned from a previous paginated
\code{\link[=batch_list_jobs]{list_jobs}} request where \code{maxResults} was used and
the results exceeded the value of that parameter. Pagination continues
from the end of the previous results that returned the \code{nextToken}
value. This value is \code{null} when there are no more results to return.

Treat this token as an opaque identifier that's only used to retrieve
the next items in a list and not for other programmatic purposes.}

\item{filters}{The filter to apply to the query. Only one filter can be used at a time.
When the filter is used, \code{jobStatus} is ignored. The filter doesn't
apply to child jobs in an array or multi-node parallel (MNP) jobs. The
results are sorted by the \code{createdAt} field, with the most recent jobs
being first.

\strong{JOB_NAME}

The value of the filter is a case-insensitive match for the job name. If
the value ends with an asterisk (\emph{), the filter matches any job name
that begins with the string before the '}'. This corresponds to the
\code{jobName} value. For example, \code{test1} matches both \code{Test1} and \code{test1},
and \verb{test1*} matches both \code{test1} and \code{Test10}. When the \code{JOB_NAME}
filter is used, the results are grouped by the job name and version.

\strong{JOB_DEFINITION}

The value for the filter is the name or Amazon Resource Name (ARN) of
the job definition. This corresponds to the \code{jobDefinition} value. The
value is case sensitive. When the value for the filter is the job
definition name, the results include all the jobs that used any revision
of that job definition name. If the value ends with an asterisk (\emph{),
the filter matches any job definition name that begins with the string
before the '}'. For example, \code{jd1} matches only \code{jd1}, and \verb{jd1*}
matches both \code{jd1} and \code{jd1A}. The version of the job definition that's
used doesn't affect the sort order. When the \code{JOB_DEFINITION} filter is
used and the ARN is used (which is in the form
\verb{arn:$\{Partition\}:batch:$\{Region\}:$\{Account\}:job-definition/$\{JobDefinitionName\}:$\{Revision\}}),
the results include jobs that used the specified revision of the job
definition. Asterisk (*) isn't supported when the ARN is used.

\strong{BEFORE_CREATED_AT}

The value for the filter is the time that's before the job was created.
This corresponds to the \code{createdAt} value. The value is a string
representation of the number of milliseconds since 00:00:00 UTC
(midnight) on January 1, 1970.

\strong{AFTER_CREATED_AT}

The value for the filter is the time that's after the job was created.
This corresponds to the \code{createdAt} value. The value is a string
representation of the number of milliseconds since 00:00:00 UTC
(midnight) on January 1, 1970.}
}
\description{
Returns a list of Batch jobs.

See \url{https://www.paws-r-sdk.com/docs/batch_list_jobs/} for full documentation.
}
\keyword{internal}
