% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_untag_resource}
\alias{lambda_untag_resource}
\title{Removes tags from a function}
\usage{
lambda_untag_resource(Resource, TagKeys)
}
\arguments{
\item{Resource}{[required] The function\'s Amazon Resource Name (ARN).}

\item{TagKeys}{[required] A list of tag keys to remove from the function.}
}
\description{
Removes
\href{https://docs.aws.amazon.com/lambda/latest/dg/tagging.html}{tags} from a
function.
}
\section{Request syntax}{
\preformatted{svc$untag_resource(
  Resource = "string",
  TagKeys = list(
    "string"
  )
)
}
}

\examples{
\dontrun{
# The following example removes the tag with the key name DEPARTMENT tag
# from the my-function Lambda function.
svc$untag_resource(
  Resource = "arn:aws:lambda:us-west-2:123456789012:function:my-function",
  TagKeys = list(
    "DEPARTMENT"
  )
)
}

}
\keyword{internal}
