% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_delete_vpn_connection}
\alias{ec2_delete_vpn_connection}
\title{Deletes the specified VPN connection}
\usage{
ec2_delete_vpn_connection(VpnConnectionId, DryRun)
}
\arguments{
\item{VpnConnectionId}{[required] The ID of the VPN connection.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Deletes the specified VPN connection.
}
\details{
If you\'re deleting the VPC and its associated components, we recommend
that you detach the virtual private gateway from the VPC and delete the
VPC before deleting the VPN connection. If you believe that the tunnel
credentials for your VPN connection have been compromised, you can
delete the VPN connection and create a new one that has new keys,
without needing to delete the VPC or virtual private gateway. If you
create a new VPN connection, you must reconfigure the customer gateway
device using the new configuration information returned with the new VPN
connection ID.

For certificate-based authentication, delete all AWS Certificate Manager
(ACM) private certificates used for the AWS-side tunnel endpoints for
the VPN connection before deleting the VPN connection.
}
\section{Request syntax}{
\preformatted{svc$delete_vpn_connection(
  VpnConnectionId = "string",
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
