% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticbeanstalk_operations.R
\name{elasticbeanstalk_update_application}
\alias{elasticbeanstalk_update_application}
\title{Updates the specified application to have the specified properties}
\usage{
elasticbeanstalk_update_application(ApplicationName, Description)
}
\arguments{
\item{ApplicationName}{[required] The name of the application to update. If no such application is found,
\code{UpdateApplication} returns an \code{InvalidParameterValue} error.}

\item{Description}{A new description for the application.

Default: If not specified, AWS Elastic Beanstalk does not update the
description.}
}
\description{
Updates the specified application to have the specified properties.
}
\details{
If a property (for example, \code{description}) is not provided, the value
remains unchanged. To clear these properties, specify an empty string.
}
\section{Request syntax}{
\preformatted{svc$update_application(
  ApplicationName = "string",
  Description = "string"
)
}
}

\examples{
\dontrun{
# The following operation updates the description of an application named
# my-app:
svc$update_application(
  ApplicationName = "my-app",
  Description = "my Elastic Beanstalk application"
)
}

}
\keyword{internal}
