% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_security_groups}
\alias{ec2_describe_security_groups}
\title{Describes the specified security groups or all of your security groups}
\usage{
ec2_describe_security_groups(Filters, GroupIds, GroupNames, DryRun,
  NextToken, MaxResults)
}
\arguments{
\item{Filters}{The filters. If using multiple filters for rules, the results include
security groups for which any combination of rules - not necessarily a
single rule - match all filters.
\itemize{
\item \code{description} - The description of the security group.
\item \code{egress.ip-permission.cidr} - An IPv4 CIDR block for an outbound
security group rule.
\item \code{egress.ip-permission.from-port} - For an outbound rule, the start
of port range for the TCP and UDP protocols, or an ICMP type number.
\item \code{egress.ip-permission.group-id} - The ID of a security group that
has been referenced in an outbound security group rule.
\item \code{egress.ip-permission.group-name} - The name of a security group
that has been referenced in an outbound security group rule.
\item \code{egress.ip-permission.ipv6-cidr} - An IPv6 CIDR block for an
outbound security group rule.
\item \code{egress.ip-permission.prefix-list-id} - The ID (prefix) of the AWS
service to which a security group rule allows outbound access.
\item \code{egress.ip-permission.protocol} - The IP protocol for an outbound
security group rule (\code{tcp} \\| \code{udp} \\| \code{icmp} or a protocol number).
\item \code{egress.ip-permission.to-port} - For an outbound rule, the end of
port range for the TCP and UDP protocols, or an ICMP code.
\item \code{egress.ip-permission.user-id} - The ID of an AWS account that has
been referenced in an outbound security group rule.
\item \code{group-id} - The ID of the security group.
\item \code{group-name} - The name of the security group.
\item \code{ip-permission.cidr} - An IPv4 CIDR block for an inbound security
group rule.
\item \code{ip-permission.from-port} - For an inbound rule, the start of port
range for the TCP and UDP protocols, or an ICMP type number.
\item \code{ip-permission.group-id} - The ID of a security group that has been
referenced in an inbound security group rule.
\item \code{ip-permission.group-name} - The name of a security group that has
been referenced in an inbound security group rule.
\item \code{ip-permission.ipv6-cidr} - An IPv6 CIDR block for an inbound
security group rule.
\item \code{ip-permission.prefix-list-id} - The ID (prefix) of the AWS service
from which a security group rule allows inbound access.
\item \code{ip-permission.protocol} - The IP protocol for an inbound security
group rule (\code{tcp} \\| \code{udp} \\| \code{icmp} or a protocol number).
\item \code{ip-permission.to-port} - For an inbound rule, the end of port range
for the TCP and UDP protocols, or an ICMP code.
\item \code{ip-permission.user-id} - The ID of an AWS account that has been
referenced in an inbound security group rule.
\item \code{owner-id} - The AWS account ID of the owner of the security group.
\item \code{tag}:\\<key\\> - The key/value combination of a tag assigned to the
resource. Use the tag key in the filter name and the tag value as
the filter value. For example, to find all resources that have a tag
with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner} for
the filter name and \code{TeamA} for the filter value.
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources assigned a tag with a specific key,
regardless of the tag value.
\item \code{vpc-id} - The ID of the VPC specified when the security group was
created.
}}

\item{GroupIds}{The IDs of the security groups. Required for security groups in a
nondefault VPC.

Default: Describes all your security groups.}

\item{GroupNames}{[EC2-Classic and default VPC only] The names of the security groups.
You can specify either the security group name or the security group ID.
For security groups in a nondefault VPC, use the \code{group-name} filter to
describe security groups by name.

Default: Describes all your security groups.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{NextToken}{The token to request the next page of results.}

\item{MaxResults}{The maximum number of results to return in a single call. To retrieve
the remaining results, make another request with the returned
\code{NextToken} value. This value can be between 5 and 1000. If this
parameter is not specified, then all results are returned.}
}
\description{
Describes the specified security groups or all of your security groups.
}
\details{
A security group is for use with instances either in the EC2-Classic
platform or in a specific VPC. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html}{Amazon EC2 Security Groups}
in the \emph{Amazon Elastic Compute Cloud User Guide} and \href{https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html}{Security Groups for Your VPC}
in the \emph{Amazon Virtual Private Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$describe_security_groups(
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  GroupIds = list(
    "string"
  ),
  GroupNames = list(
    "string"
  ),
  DryRun = TRUE|FALSE,
  NextToken = "string",
  MaxResults = 123
)
}
}

\examples{
\dontrun{
# This example describes the specified security group.
svc$describe_security_groups(
  GroupIds = list(
    "sg-903004f8"
  )
)

# This example describes the security groups that include the specified
# tag (Purpose=test).
svc$describe_security_groups(
  Filters = list(
    list(
      Name = "tag:Purpose",
      Values = list(
        "test"
      )
    )
  )
)
}

}
\keyword{internal}
