% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_attach_volume}
\alias{ec2_attach_volume}
\title{Attaches an EBS volume to a running or stopped instance and exposes it
to the instance with the specified device name}
\usage{
ec2_attach_volume(Device, InstanceId, VolumeId, DryRun)
}
\arguments{
\item{Device}{[required] The device name (for example, \verb{/dev/sdh} or \code{xvdh}).}

\item{InstanceId}{[required] The ID of the instance.}

\item{VolumeId}{[required] The ID of the EBS volume. The volume and instance must be within the
same Availability Zone.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Attaches an EBS volume to a running or stopped instance and exposes it
to the instance with the specified device name.
}
\details{
Encrypted EBS volumes must be attached to instances that support Amazon
EBS encryption. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html}{Amazon EBS Encryption}
in the \emph{Amazon Elastic Compute Cloud User Guide}.

After you attach an EBS volume, you must make it available. For more
information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-using-volumes.html}{Making an EBS Volume Available For Use}.

If a volume has an AWS Marketplace product code:
\itemize{
\item The volume can be attached only to a stopped instance.
\item AWS Marketplace product codes are copied from the volume to the
instance.
\item You must be subscribed to the product.
\item The instance type and operating system of the instance must support
the product. For example, you can\'t detach a volume from a Windows
instance and attach it to a Linux instance.
}

For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-attaching-volume.html}{Attaching Amazon EBS Volumes}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$attach_volume(
  Device = "string",
  InstanceId = "string",
  VolumeId = "string",
  DryRun = TRUE|FALSE
)
}
}

\examples{
\dontrun{
# This example attaches a volume (`vol-1234567890abcdef0`) to an
# instance (`i-01474ef662b89480`) as `/dev/sdf`.
svc$attach_volume(
  Device = "/dev/sdf",
  InstanceId = "i-01474ef662b89480",
  VolumeId = "vol-1234567890abcdef0"
)
}

}
\keyword{internal}
