% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_describe_services}
\alias{ecs_describe_services}
\title{Describes the specified services running in your cluster}
\usage{
ecs_describe_services(cluster, services, include)
}
\arguments{
\item{cluster}{The short name or full Amazon Resource Name (ARN)the cluster that hosts
the service to describe. If you do not specify a cluster, the default
cluster is assumed. This parameter is required if the service or
services you are describing were launched in any cluster other than the
default cluster.}

\item{services}{[required] A list of services to describe. You may specify up to 10 services to
describe in a single operation.}

\item{include}{Specifies whether you want to see the resource tags for the service. If
\code{TAGS} is specified, the tags are included in the response. If this
field is omitted, tags are not included in the response.}
}
\description{
Describes the specified services running in your cluster.
}
\section{Request syntax}{
\preformatted{svc$describe_services(
  cluster = "string",
  services = list(
    "string"
  ),
  include = list(
    "TAGS"
  )
)
}
}

\examples{
# This example provides descriptive information about the service named
# `ecs-simple-service`.
\dontrun{svc$describe_services(
  services = list(
    "ecs-simple-service"
  )
)}

}
\keyword{internal}
