% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecr_operations.R
\name{ecr_put_image_tag_mutability}
\alias{ecr_put_image_tag_mutability}
\title{Updates the image tag mutability settings for a repository}
\usage{
ecr_put_image_tag_mutability(registryId, repositoryName,
  imageTagMutability)
}
\arguments{
\item{registryId}{The AWS account ID associated with the registry that contains the
repository in which to update the image tag mutability settings. If you
do not specify a registry, the default registry is assumed.}

\item{repositoryName}{[required] The name of the repository in which to update the image tag mutability
settings.}

\item{imageTagMutability}{[required] The tag mutability setting for the repository. If \code{MUTABLE} is
specified, image tags can be overwritten. If \code{IMMUTABLE} is specified,
all image tags within the repository will be immutable which will
prevent them from being overwritten.}
}
\description{
Updates the image tag mutability settings for a repository. When a
repository is configured with tag immutability, all image tags within
the repository will be prevented them from being overwritten. For more
information, see \href{https://docs.aws.amazon.com/AmazonECR/latest/userguide/image-tag-mutability.html}{Image Tag Mutability}
in the \emph{Amazon Elastic Container Registry User Guide}.
}
\section{Request syntax}{
\preformatted{svc$put_image_tag_mutability(
  registryId = "string",
  repositoryName = "string",
  imageTagMutability = "MUTABLE"|"IMMUTABLE"
)
}
}

\keyword{internal}
