% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_snapshot_attribute}
\alias{ec2_describe_snapshot_attribute}
\title{Describes the specified attribute of the specified snapshot}
\usage{
ec2_describe_snapshot_attribute(Attribute, SnapshotId, DryRun)
}
\arguments{
\item{Attribute}{[required] The snapshot attribute you would like to view.}

\item{SnapshotId}{[required] The ID of the EBS snapshot.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Describes the specified attribute of the specified snapshot. You can
specify only one attribute at a time.
}
\details{
For more information about EBS snapshots, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSSnapshots.html}{Amazon EBS Snapshots}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$describe_snapshot_attribute(
  Attribute = "productCodes"|"createVolumePermission",
  SnapshotId = "string",
  DryRun = TRUE|FALSE
)
}
}

\examples{
# This example describes the `createVolumePermission` attribute on a
# snapshot with the snapshot ID of `snap-066877671789bd71b`.
\dontrun{svc$describe_snapshot_attribute(
  Attribute = "createVolumePermission",
  SnapshotId = "snap-066877671789bd71b"
)}

}
\keyword{internal}
