% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_traffic_mirror_filter_rule}
\alias{ec2_create_traffic_mirror_filter_rule}
\title{Creates a Traffic Mirror filter rule}
\usage{
ec2_create_traffic_mirror_filter_rule(TrafficMirrorFilterId,
  TrafficDirection, RuleNumber, RuleAction, DestinationPortRange,
  SourcePortRange, Protocol, DestinationCidrBlock, SourceCidrBlock,
  Description, DryRun, ClientToken)
}
\arguments{
\item{TrafficMirrorFilterId}{[required] The ID of the filter that this rule is associated with.}

\item{TrafficDirection}{[required] The type of traffic (\code{ingress} \\| \code{egress}).}

\item{RuleNumber}{[required] The number of the Traffic Mirror rule. This number must be unique for
each Traffic Mirror rule in a given direction. The rules are processed
in ascending order by rule number.}

\item{RuleAction}{[required] The action to take (\code{accept} \\| \code{reject}) on the filtered traffic.}

\item{DestinationPortRange}{The destination port range.}

\item{SourcePortRange}{The source port range.}

\item{Protocol}{The protocol, for example UDP, to assign to the Traffic Mirror rule.

For information about the protocol value, see \href{https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml}{Protocol Numbers}
on the Internet Assigned Numbers Authority (IANA) website.}

\item{DestinationCidrBlock}{[required] The destination CIDR block to assign to the Traffic Mirror rule.}

\item{SourceCidrBlock}{[required] The source CIDR block to assign to the Traffic Mirror rule.}

\item{Description}{The description of the Traffic Mirror rule.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{ClientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{How to Ensure Idempotency}.}
}
\description{
Creates a Traffic Mirror filter rule.
}
\details{
A Traffic Mirror rule defines the Traffic Mirror source traffic to
mirror.

You need the Traffic Mirror filter ID when you create the rule.
}
\section{Request syntax}{
\preformatted{svc$create_traffic_mirror_filter_rule(
  TrafficMirrorFilterId = "string",
  TrafficDirection = "ingress"|"egress",
  RuleNumber = 123,
  RuleAction = "accept"|"reject",
  DestinationPortRange = list(
    FromPort = 123,
    ToPort = 123
  ),
  SourcePortRange = list(
    FromPort = 123,
    ToPort = 123
  ),
  Protocol = 123,
  DestinationCidrBlock = "string",
  SourceCidrBlock = "string",
  Description = "string",
  DryRun = TRUE|FALSE,
  ClientToken = "string"
)
}
}

\keyword{internal}
