% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_capacity_reservation}
\alias{ec2_create_capacity_reservation}
\title{Creates a new Capacity Reservation with the specified attributes}
\usage{
ec2_create_capacity_reservation(ClientToken, InstanceType,
  InstancePlatform, AvailabilityZone, AvailabilityZoneId, Tenancy,
  InstanceCount, EbsOptimized, EphemeralStorage, EndDate, EndDateType,
  InstanceMatchCriteria, TagSpecifications, DryRun)
}
\arguments{
\item{ClientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{How to Ensure Idempotency}.

Constraint: Maximum 64 ASCII characters.}

\item{InstanceType}{[required] The instance type for which to reserve capacity. For more information,
see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html}{Instance Types}
in the \emph{Amazon Elastic Compute Cloud User Guide}.}

\item{InstancePlatform}{[required] The type of operating system for which to reserve capacity.}

\item{AvailabilityZone}{The Availability Zone in which to create the Capacity Reservation.}

\item{AvailabilityZoneId}{The ID of the Availability Zone in which to create the Capacity
Reservation.}

\item{Tenancy}{Indicates the tenancy of the Capacity Reservation. A Capacity
Reservation can have one of the following tenancy settings:
\itemize{
\item \code{default} - The Capacity Reservation is created on hardware that is
shared with other AWS accounts.
\item \code{dedicated} - The Capacity Reservation is created on single-tenant
hardware that is dedicated to a single AWS account.
}}

\item{InstanceCount}{[required] The number of instances for which to reserve capacity.}

\item{EbsOptimized}{Indicates whether the Capacity Reservation supports EBS-optimized
instances. This optimization provides dedicated throughput to Amazon EBS
and an optimized configuration stack to provide optimal I/O performance.
This optimization isn\'t available with all instance types. Additional
usage charges apply when using an EBS- optimized instance.}

\item{EphemeralStorage}{Indicates whether the Capacity Reservation supports instances with
temporary, block-level storage.}

\item{EndDate}{The date and time at which the Capacity Reservation expires. When a
Capacity Reservation expires, the reserved capacity is released and you
can no longer launch instances into it. The Capacity Reservation\'s
state changes to \code{expired} when it reaches its end date and time.

You must provide an \code{EndDate} value if \code{EndDateType} is \code{limited}. Omit
\code{EndDate} if \code{EndDateType} is \code{unlimited}.

If the \code{EndDateType} is \code{limited}, the Capacity Reservation is cancelled
within an hour from the specified time. For example, if you specify
5/31/2019, 13:30:55, the Capacity Reservation is guaranteed to end
between 13:30:55 and 14:30:55 on 5/31/2019.}

\item{EndDateType}{Indicates the way in which the Capacity Reservation ends. A Capacity
Reservation can have one of the following end types:
\itemize{
\item \code{unlimited} - The Capacity Reservation remains active until you
explicitly cancel it. Do not provide an \code{EndDate} if the
\code{EndDateType} is \code{unlimited}.
\item \code{limited} - The Capacity Reservation expires automatically at a
specified date and time. You must provide an \code{EndDate} value if the
\code{EndDateType} value is \code{limited}.
}}

\item{InstanceMatchCriteria}{Indicates the type of instance launches that the Capacity Reservation
accepts. The options include:
\itemize{
\item \code{open} - The Capacity Reservation automatically matches all
instances that have matching attributes (instance type, platform,
and Availability Zone). Instances that have matching attributes run
in the Capacity Reservation automatically without specifying any
additional parameters.
\item \code{targeted} - The Capacity Reservation only accepts instances that
have matching attributes (instance type, platform, and Availability
Zone), and explicitly target the Capacity Reservation. This ensures
that only permitted instances can use the reserved capacity.
}

Default: \code{open}}

\item{TagSpecifications}{The tags to apply to the Capacity Reservation during launch.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Creates a new Capacity Reservation with the specified attributes.
}
\details{
Capacity Reservations enable you to reserve capacity for your Amazon EC2
instances in a specific Availability Zone for any duration. This gives
you the flexibility to selectively add capacity reservations and still
get the Regional RI discounts for that usage. By creating Capacity
Reservations, you ensure that you always have access to Amazon EC2
capacity when you need it, for as long as you need it. For more
information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-capacity-reservations.html}{Capacity Reservations}
in the \emph{Amazon Elastic Compute Cloud User Guide}.

Your request to create a Capacity Reservation could fail if Amazon EC2
does not have sufficient capacity to fulfill the request. If your
request fails due to Amazon EC2 capacity constraints, either try again
at a later time, try in a different Availability Zone, or request a
smaller capacity reservation. If your application is flexible across
instance types and sizes, try to create a Capacity Reservation with
different instance attributes.

Your request could also fail if the requested quantity exceeds your
On-Demand Instance limit for the selected instance type. If your request
fails due to limit constraints, increase your On-Demand Instance limit
for the required instance type and try again. For more information about
increasing your instance limits, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html}{Amazon EC2 Service Limits}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_capacity_reservation(
  ClientToken = "string",
  InstanceType = "string",
  InstancePlatform = "Linux/UNIX"|"Red Hat Enterprise Linux"|"SUSE Linux"|"Windows"|"Windows with SQL Server"|"Windows with SQL Server Enterprise"|"Windows with SQL Server Standard"|"Windows with SQL Server Web"|"Linux with SQL Server Standard"|"Linux with SQL Server Web"|"Linux with SQL Server Enterprise",
  AvailabilityZone = "string",
  AvailabilityZoneId = "string",
  Tenancy = "default"|"dedicated",
  InstanceCount = 123,
  EbsOptimized = TRUE|FALSE,
  EphemeralStorage = TRUE|FALSE,
  EndDate = as.POSIXct(
    "2015-01-01"
  ),
  EndDateType = "unlimited"|"limited",
  InstanceMatchCriteria = "open"|"targeted",
  TagSpecifications = list(
    list(
      ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"elastic-ip"|"fleet"|"fpga-image"|"host-reservation"|"image"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"natgateway"|"network-acl"|"network-interface"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway",
      Tags = list(
        list(
          Key = "string",
          Value = "string"
        )
      )
    )
  ),
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
