% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eks_operations.R
\name{eks_list_clusters}
\alias{eks_list_clusters}
\title{Lists the Amazon EKS clusters in your AWS account in the specified
Region}
\usage{
eks_list_clusters(maxResults, nextToken)
}
\arguments{
\item{maxResults}{The maximum number of cluster results returned by \code{ListClusters} in
paginated output. When you use this parameter, \code{ListClusters} returns
only \code{maxResults} results in a single page along with a \code{nextToken}
response element. You can see the remaining results of the initial
request by sending another \code{ListClusters} request with the returned
\code{nextToken} value. This value can be between 1 and 100. If you don't
use this parameter, \code{ListClusters} returns up to 100 results and a
\code{nextToken} value if applicable.}

\item{nextToken}{The \code{nextToken} value returned from a previous paginated \code{ListClusters}
request where \code{maxResults} was used and the results exceeded the value
of that parameter. Pagination continues from the end of the previous
results that returned the \code{nextToken} value.

This token should be treated as an opaque identifier that is used only
to retrieve the next items in a list and not for other programmatic
purposes.}
}
\description{
Lists the Amazon EKS clusters in your AWS account in the specified
Region.
}
\section{Request syntax}{
\preformatted{svc$list_clusters(
  maxResults = 123,
  nextToken = "string"
)
}
}

\examples{
# This example command lists all of your available clusters in your
# default region.
\donttest{svc$list_clusters()}

}
\keyword{internal}
