% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_associate_iam_instance_profile}
\alias{ec2_associate_iam_instance_profile}
\title{Associates an IAM instance profile with a running or stopped instance}
\usage{
ec2_associate_iam_instance_profile(IamInstanceProfile, InstanceId)
}
\arguments{
\item{IamInstanceProfile}{[required] The IAM instance profile.}

\item{InstanceId}{[required] The ID of the instance.}
}
\description{
Associates an IAM instance profile with a running or stopped instance.
You cannot associate more than one IAM instance profile with an
instance.
}
\section{Request syntax}{
\preformatted{svc$associate_iam_instance_profile(
  IamInstanceProfile = list(
    Arn = "string",
    Name = "string"
  ),
  InstanceId = "string"
)
}
}

\examples{
# This example associates an IAM instance profile named admin-role with
# the specified instance.
\donttest{svc$associate_iam_instance_profile(
  IamInstanceProfile = list(
    Name = "admin-role"
  ),
  InstanceId = "i-123456789abcde123"
)}

}
\keyword{internal}
