% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_invoke_async}
\alias{lambda_invoke_async}
\title{For asynchronous function invocation, use Invoke}
\usage{
lambda_invoke_async(FunctionName, InvokeArgs)
}
\arguments{
\item{FunctionName}{[required] The name of the Lambda function.

\strong{Name formats}
\itemize{
\item \strong{Function name} - \code{my-function}.
\item \strong{Function ARN} -
\code{arn:aws:lambda:us-west-2:123456789012:function:my-function}.
\item \strong{Partial ARN} - \code{123456789012:function:my-function}.
}

The length constraint applies only to the full ARN. If you specify only
the function name, it is limited to 64 characters in length.}

\item{InvokeArgs}{[required] The JSON that you want to provide to your Lambda function as input.}
}
\description{
For asynchronous function invocation, use Invoke.
}
\details{
Invokes a function asynchronously.
}
\section{Request syntax}{
\preformatted{svc$invoke_async(
  FunctionName = "string",
  InvokeArgs = raw
)
}
}

\examples{
# This operation invokes a Lambda function asynchronously
\donttest{svc$invoke_async(
  FunctionName = "myFunction",
  InvokeArgs = "fileb://file-path/input.json"
)}

}
\keyword{internal}
