% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_tag_resource}
\alias{ecs_tag_resource}
\title{Associates the specified tags to a resource with the specified
resourceArn}
\usage{
ecs_tag_resource(resourceArn, tags)
}
\arguments{
\item{resourceArn}{[required] The Amazon Resource Name (ARN) of the resource to which to add tags.
Currently, the supported resources are Amazon ECS tasks, services, task
definitions, clusters, and container instances.}

\item{tags}{[required] The tags to add to the resource. A tag is an array of key-value pairs.
Tag keys can have a maximum character length of 128 characters, and tag
values can have a maximum length of 256 characters.}
}
\description{
Associates the specified tags to a resource with the specified
\code{resourceArn}. If existing tags on a resource are not specified in the
request parameters, they are not changed. When a resource is deleted,
the tags associated with that resource are deleted as well.
}
\section{Request syntax}{
\preformatted{svc$tag_resource(
  resourceArn = "string",
  tags = list(
    list(
      key = "string",
      value = "string"
    )
  )
)
}
}

\examples{
# This example tags the 'dev' cluster with key 'team' and value 'dev'.
\donttest{svc$tag_resource(
  resourceArn = "arn:aws:ecs:region:aws_account_id:cluster/dev",
  tags = list(
    list(
      key = "team",
      value = "dev"
    )
  )
)}

}
\keyword{internal}
