% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_create_load_balancer}
\alias{lightsail_create_load_balancer}
\title{Creates a Lightsail load balancer}
\usage{
lightsail_create_load_balancer(loadBalancerName, instancePort,
  healthCheckPath, certificateName, certificateDomainName,
  certificateAlternativeNames, tags)
}
\arguments{
\item{loadBalancerName}{[required] The name of your load balancer.}

\item{instancePort}{[required] The instance port where you're creating your load balancer.}

\item{healthCheckPath}{The path you provided to perform the load balancer health check. If you
didn't specify a health check path, Lightsail uses the root path of your
website (e.g., \code{"/"}).

You may want to specify a custom health check path other than the root
of your application if your home page loads slowly or has a lot of media
or scripting on it.}

\item{certificateName}{The name of the SSL/TLS certificate.

If you specify \code{certificateName}, then \code{certificateDomainName} is
required (and vice-versa).}

\item{certificateDomainName}{The domain name with which your certificate is associated (e.g.,
\code{example.com}).

If you specify \code{certificateDomainName}, then \code{certificateName} is
required (and vice-versa).}

\item{certificateAlternativeNames}{The optional alternative domains and subdomains to use with your SSL/TLS
certificate (e.g., \code{www.example.com}, \code{example.com}, \code{m.example.com},
\code{blog.example.com}).}

\item{tags}{The tag keys and optional values to add to the resource during create.

Use the \code{\link[=lightsail_tag_resource]{tag_resource}} action to tag a
resource after it's created.}
}
\value{
A list with the following syntax:\preformatted{list(
  operations = list(
    list(
      id = "string",
      resourceName = "string",
      resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
      createdAt = as.POSIXct(
        "2015-01-01"
      ),
      location = list(
        availabilityZone = "string",
        regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
      ),
      isTerminal = TRUE|FALSE,
      operationDetails = "string",
      operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
      status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
      statusChangedAt = as.POSIXct(
        "2015-01-01"
      ),
      errorCode = "string",
      errorDetails = "string"
    )
  )
)
}
}
\description{
Creates a Lightsail load balancer. To learn more about deciding whether
to load balance your application, see Configure your Lightsail instances
for load balancing. You can create up to 5 load balancers per AWS Region
in your account.

When you create a load balancer, you can specify a unique name and port
settings. To change additional load balancer settings, use the
\code{\link[=lightsail_update_load_balancer_attribute]{update_load_balancer_attribute}}
operation.

The \verb{create load balancer} operation supports tag-based access control
via request tags. For more information, see the Lightsail Dev Guide.
}
\section{Request syntax}{
\preformatted{svc$create_load_balancer(
  loadBalancerName = "string",
  instancePort = 123,
  healthCheckPath = "string",
  certificateName = "string",
  certificateDomainName = "string",
  certificateAlternativeNames = list(
    "string"
  ),
  tags = list(
    list(
      key = "string",
      value = "string"
    )
  )
)
}
}

\keyword{internal}
