% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_update_alias}
\alias{lambda_update_alias}
\title{Updates the configuration of a Lambda function alias}
\usage{
lambda_update_alias(FunctionName, Name, FunctionVersion, Description,
  RoutingConfig, RevisionId)
}
\arguments{
\item{FunctionName}{[required] The name of the Lambda function.

\strong{Name formats}
\itemize{
\item \strong{Function name} - \code{MyFunction}.
\item \strong{Function ARN} -
\verb{arn:aws:lambda:us-west-2:123456789012:function:MyFunction}.
\item \strong{Partial ARN} - \verb{123456789012:function:MyFunction}.
}

The length constraint applies only to the full ARN. If you specify only
the function name, it is limited to 64 characters in length.}

\item{Name}{[required] The name of the alias.}

\item{FunctionVersion}{The function version that the alias invokes.}

\item{Description}{A description of the alias.}

\item{RoutingConfig}{The \href{https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html#configuring-alias-routing}{routing configuration}
of the alias.}

\item{RevisionId}{Only update the alias if the revision ID matches the ID that's
specified. Use this option to avoid modifying an alias that has changed
since you last read it.}
}
\value{
A list with the following syntax:\preformatted{list(
  AliasArn = "string",
  Name = "string",
  FunctionVersion = "string",
  Description = "string",
  RoutingConfig = list(
    AdditionalVersionWeights = list(
      123.0
    )
  ),
  RevisionId = "string"
)
}
}
\description{
Updates the configuration of a Lambda function
\href{https://docs.aws.amazon.com/lambda/latest/dg/configuration-versions.html}{alias}.
}
\section{Request syntax}{
\preformatted{svc$update_alias(
  FunctionName = "string",
  Name = "string",
  FunctionVersion = "string",
  Description = "string",
  RoutingConfig = list(
    AdditionalVersionWeights = list(
      123.0
    )
  ),
  RevisionId = "string"
)
}
}

\examples{
\dontrun{
# The following example updates the alias named BLUE to send 30\% of
# traffic to version 2 and 70\% to version 1.
svc$update_alias(
  FunctionName = "my-function",
  FunctionVersion = "2",
  Name = "BLUE",
  RoutingConfig = list(
    AdditionalVersionWeights = list(
      `1` = 0.7
    )
  )
)
}

}
\keyword{internal}
