% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticbeanstalk_operations.R
\name{elasticbeanstalk_describe_environments}
\alias{elasticbeanstalk_describe_environments}
\title{Returns descriptions for existing environments}
\usage{
elasticbeanstalk_describe_environments(ApplicationName, VersionLabel,
  EnvironmentIds, EnvironmentNames, IncludeDeleted, IncludedDeletedBackTo,
  MaxRecords, NextToken)
}
\arguments{
\item{ApplicationName}{If specified, AWS Elastic Beanstalk restricts the returned descriptions
to include only those that are associated with this application.}

\item{VersionLabel}{If specified, AWS Elastic Beanstalk restricts the returned descriptions
to include only those that are associated with this application version.}

\item{EnvironmentIds}{If specified, AWS Elastic Beanstalk restricts the returned descriptions
to include only those that have the specified IDs.}

\item{EnvironmentNames}{If specified, AWS Elastic Beanstalk restricts the returned descriptions
to include only those that have the specified names.}

\item{IncludeDeleted}{Indicates whether to include deleted environments:

\code{true}: Environments that have been deleted after
\code{IncludedDeletedBackTo} are displayed.

\code{false}: Do not include deleted environments.}

\item{IncludedDeletedBackTo}{If specified when \code{IncludeDeleted} is set to \code{true}, then environments
deleted after this date are displayed.}

\item{MaxRecords}{For a paginated request. Specify a maximum number of environments to
include in each response.

If no \code{MaxRecords} is specified, all available environments are
retrieved in a single response.}

\item{NextToken}{For a paginated request. Specify a token from a previous response page
to retrieve the next response page. All other parameter values must be
identical to the ones specified in the initial request.

If no \code{NextToken} is specified, the first page is retrieved.}
}
\value{
A list with the following syntax:\preformatted{list(
  Environments = list(
    list(
      EnvironmentName = "string",
      EnvironmentId = "string",
      ApplicationName = "string",
      VersionLabel = "string",
      SolutionStackName = "string",
      PlatformArn = "string",
      TemplateName = "string",
      Description = "string",
      EndpointURL = "string",
      CNAME = "string",
      DateCreated = as.POSIXct(
        "2015-01-01"
      ),
      DateUpdated = as.POSIXct(
        "2015-01-01"
      ),
      Status = "Aborting"|"Launching"|"Updating"|"LinkingFrom"|"LinkingTo"|"Ready"|"Terminating"|"Terminated",
      AbortableOperationInProgress = TRUE|FALSE,
      Health = "Green"|"Yellow"|"Red"|"Grey",
      HealthStatus = "NoData"|"Unknown"|"Pending"|"Ok"|"Info"|"Warning"|"Degraded"|"Severe"|"Suspended",
      Resources = list(
        LoadBalancer = list(
          LoadBalancerName = "string",
          Domain = "string",
          Listeners = list(
            list(
              Protocol = "string",
              Port = 123
            )
          )
        )
      ),
      Tier = list(
        Name = "string",
        Type = "string",
        Version = "string"
      ),
      EnvironmentLinks = list(
        list(
          LinkName = "string",
          EnvironmentName = "string"
        )
      ),
      EnvironmentArn = "string",
      OperationsRole = "string"
    )
  ),
  NextToken = "string"
)
}
}
\description{
Returns descriptions for existing environments.
}
\section{Request syntax}{
\preformatted{svc$describe_environments(
  ApplicationName = "string",
  VersionLabel = "string",
  EnvironmentIds = list(
    "string"
  ),
  EnvironmentNames = list(
    "string"
  ),
  IncludeDeleted = TRUE|FALSE,
  IncludedDeletedBackTo = as.POSIXct(
    "2015-01-01"
  ),
  MaxRecords = 123,
  NextToken = "string"
)
}
}

\examples{
\dontrun{
# The following operation retrieves information about an environment named
# my-env:
svc$describe_environments(
  EnvironmentNames = list(
    "my-env"
  )
)
}

}
\keyword{internal}
