% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_traffic_mirror_targets}
\alias{ec2_describe_traffic_mirror_targets}
\title{Information about one or more Traffic Mirror targets}
\usage{
ec2_describe_traffic_mirror_targets(TrafficMirrorTargetIds, DryRun,
  Filters, MaxResults, NextToken)
}
\arguments{
\item{TrafficMirrorTargetIds}{The ID of the Traffic Mirror targets.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{Filters}{One or more filters. The possible values are:
\itemize{
\item \code{description}: The Traffic Mirror target description.
\item \code{network-interface-id}: The ID of the Traffic Mirror session network
interface.
\item \code{network-load-balancer-arn}: The Amazon Resource Name (ARN) of the
Network Load Balancer that is associated with the session.
\item \code{owner-id}: The ID of the account that owns the Traffic Mirror
session.
\item \code{traffic-mirror-target-id}: The ID of the Traffic Mirror target.
}}

\item{MaxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.}

\item{NextToken}{The token for the next page of results.}
}
\value{
A list with the following syntax:\preformatted{list(
  TrafficMirrorTargets = list(
    list(
      TrafficMirrorTargetId = "string",
      NetworkInterfaceId = "string",
      NetworkLoadBalancerArn = "string",
      Type = "network-interface"|"network-load-balancer",
      Description = "string",
      OwnerId = "string",
      Tags = list(
        list(
          Key = "string",
          Value = "string"
        )
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Information about one or more Traffic Mirror targets.
}
\section{Request syntax}{
\preformatted{svc$describe_traffic_mirror_targets(
  TrafficMirrorTargetIds = list(
    "string"
  ),
  DryRun = TRUE|FALSE,
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
