% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_delete_transit_gateway}
\alias{ec2_delete_transit_gateway}
\title{Deletes the specified transit gateway}
\usage{
ec2_delete_transit_gateway(TransitGatewayId, DryRun)
}
\arguments{
\item{TransitGatewayId}{[required] The ID of the transit gateway.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\value{
A list with the following syntax:\preformatted{list(
  TransitGateway = list(
    TransitGatewayId = "string",
    TransitGatewayArn = "string",
    State = "pending"|"available"|"modifying"|"deleting"|"deleted",
    OwnerId = "string",
    Description = "string",
    CreationTime = as.POSIXct(
      "2015-01-01"
    ),
    Options = list(
      AmazonSideAsn = 123,
      TransitGatewayCidrBlocks = list(
        "string"
      ),
      AutoAcceptSharedAttachments = "enable"|"disable",
      DefaultRouteTableAssociation = "enable"|"disable",
      AssociationDefaultRouteTableId = "string",
      DefaultRouteTablePropagation = "enable"|"disable",
      PropagationDefaultRouteTableId = "string",
      VpnEcmpSupport = "enable"|"disable",
      DnsSupport = "enable"|"disable",
      MulticastSupport = "enable"|"disable"
    ),
    Tags = list(
      list(
        Key = "string",
        Value = "string"
      )
    )
  )
)
}
}
\description{
Deletes the specified transit gateway.
}
\section{Request syntax}{
\preformatted{svc$delete_transit_gateway(
  TransitGatewayId = "string",
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
