% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_update_container_service}
\alias{lightsail_update_container_service}
\title{Updates the configuration of your Amazon Lightsail container service,
such as its power, scale, and public domain names}
\usage{
lightsail_update_container_service(serviceName, power, scale,
  isDisabled, publicDomainNames)
}
\arguments{
\item{serviceName}{[required] The name of the container service to update.}

\item{power}{The power for the container service.

The power specifies the amount of memory, vCPUs, and base monthly cost
of each node of the container service. The \code{power} and \code{scale} of a
container service makes up its configured capacity. To determine the
monthly price of your container service, multiply the base price of the
\code{power} with the \code{scale} (the number of nodes) of the service.

Use the
\code{\link[=lightsail_get_container_service_powers]{get_container_service_powers}}
action to view the specifications of each power option.}

\item{scale}{The scale for the container service.

The scale specifies the allocated compute nodes of the container
service. The \code{power} and \code{scale} of a container service makes up its
configured capacity. To determine the monthly price of your container
service, multiply the base price of the \code{power} with the \code{scale} (the
number of nodes) of the service.}

\item{isDisabled}{A Boolean value to indicate whether the container service is disabled.}

\item{publicDomainNames}{The public domain names to use with the container service, such as
\code{example.com} and \code{www.example.com}.

You can specify up to four public domain names for a container service.
The domain names that you specify are used when you create a deployment
with a container configured as the public endpoint of your container
service.

If you don't specify public domain names, then you can use the default
domain of the container service.

You must create and validate an SSL/TLS certificate before you can use
public domain names with your container service. Use the
\code{\link[=lightsail_create_certificate]{create_certificate}} action to create a
certificate for the public domain names you want to use with your
container service.

You can specify public domain names using a string to array map as shown
in the example later on this page.}
}
\value{
A list with the following syntax:\preformatted{list(
  containerService = list(
    containerServiceName = "string",
    arn = "string",
    createdAt = as.POSIXct(
      "2015-01-01"
    ),
    location = list(
      availabilityZone = "string",
      regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
    ),
    resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
    tags = list(
      list(
        key = "string",
        value = "string"
      )
    ),
    power = "nano"|"micro"|"small"|"medium"|"large"|"xlarge",
    powerId = "string",
    state = "PENDING"|"READY"|"RUNNING"|"UPDATING"|"DELETING"|"DISABLED",
    scale = 123,
    currentDeployment = list(
      version = 123,
      state = "ACTIVATING"|"ACTIVE"|"INACTIVE"|"FAILED",
      containers = list(
        list(
          image = "string",
          command = list(
            "string"
          ),
          environment = list(
            "string"
          ),
          ports = list(
            "HTTP"|"HTTPS"|"TCP"|"UDP"
          )
        )
      ),
      publicEndpoint = list(
        containerName = "string",
        containerPort = 123,
        healthCheck = list(
          healthyThreshold = 123,
          unhealthyThreshold = 123,
          timeoutSeconds = 123,
          intervalSeconds = 123,
          path = "string",
          successCodes = "string"
        )
      ),
      createdAt = as.POSIXct(
        "2015-01-01"
      )
    ),
    nextDeployment = list(
      version = 123,
      state = "ACTIVATING"|"ACTIVE"|"INACTIVE"|"FAILED",
      containers = list(
        list(
          image = "string",
          command = list(
            "string"
          ),
          environment = list(
            "string"
          ),
          ports = list(
            "HTTP"|"HTTPS"|"TCP"|"UDP"
          )
        )
      ),
      publicEndpoint = list(
        containerName = "string",
        containerPort = 123,
        healthCheck = list(
          healthyThreshold = 123,
          unhealthyThreshold = 123,
          timeoutSeconds = 123,
          intervalSeconds = 123,
          path = "string",
          successCodes = "string"
        )
      ),
      createdAt = as.POSIXct(
        "2015-01-01"
      )
    ),
    isDisabled = TRUE|FALSE,
    principalArn = "string",
    privateDomainName = "string",
    publicDomainNames = list(
      list(
        "string"
      )
    ),
    url = "string"
  )
)
}
}
\description{
Updates the configuration of your Amazon Lightsail container service,
such as its power, scale, and public domain names.
}
\section{Request syntax}{
\preformatted{svc$update_container_service(
  serviceName = "string",
  power = "nano"|"micro"|"small"|"medium"|"large"|"xlarge",
  scale = 123,
  isDisabled = TRUE|FALSE,
  publicDomainNames = list(
    list(
      "string"
    )
  )
)
}
}

\keyword{internal}
