% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_publish_layer_version}
\alias{lambda_publish_layer_version}
\title{Creates an AWS Lambda layer from a ZIP archive}
\usage{
lambda_publish_layer_version(LayerName, Description, Content,
  CompatibleRuntimes, LicenseInfo)
}
\arguments{
\item{LayerName}{[required] The name or Amazon Resource Name (ARN) of the layer.}

\item{Description}{The description of the version.}

\item{Content}{[required] The function layer archive.}

\item{CompatibleRuntimes}{A list of compatible \href{https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html}{function runtimes}.
Used for filtering with \code{\link[=lambda_list_layers]{list_layers}} and
\code{\link[=lambda_list_layer_versions]{list_layer_versions}}.}

\item{LicenseInfo}{The layer's software license. It can be any of the following:
\itemize{
\item An \href{https://spdx.org/licenses/}{SPDX license identifier}. For
example, \code{MIT}.
\item The URL of a license hosted on the internet. For example,
\verb{https://opensource.org/licenses/MIT}.
\item The full text of the license.
}}
}
\value{
A list with the following syntax:\preformatted{list(
  Content = list(
    Location = "string",
    CodeSha256 = "string",
    CodeSize = 123,
    SigningProfileVersionArn = "string",
    SigningJobArn = "string"
  ),
  LayerArn = "string",
  LayerVersionArn = "string",
  Description = "string",
  CreatedDate = "string",
  Version = 123,
  CompatibleRuntimes = list(
    "nodejs"|"nodejs4.3"|"nodejs6.10"|"nodejs8.10"|"nodejs10.x"|"nodejs12.x"|"java8"|"java8.al2"|"java11"|"python2.7"|"python3.6"|"python3.7"|"python3.8"|"dotnetcore1.0"|"dotnetcore2.0"|"dotnetcore2.1"|"dotnetcore3.1"|"nodejs4.3-edge"|"go1.x"|"ruby2.5"|"ruby2.7"|"provided"|"provided.al2"
  ),
  LicenseInfo = "string"
)
}
}
\description{
Creates an \href{https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html}{AWS Lambda layer}
from a ZIP archive. Each time you call
\code{\link[=lambda_publish_layer_version]{publish_layer_version}} with the same
layer name, a new version is created.

Add layers to your function with
\code{\link[=lambda_create_function]{create_function}} or
\code{\link[=lambda_update_function_configuration]{update_function_configuration}}.
}
\section{Request syntax}{
\preformatted{svc$publish_layer_version(
  LayerName = "string",
  Description = "string",
  Content = list(
    S3Bucket = "string",
    S3Key = "string",
    S3ObjectVersion = "string",
    ZipFile = raw
  ),
  CompatibleRuntimes = list(
    "nodejs"|"nodejs4.3"|"nodejs6.10"|"nodejs8.10"|"nodejs10.x"|"nodejs12.x"|"java8"|"java8.al2"|"java11"|"python2.7"|"python3.6"|"python3.7"|"python3.8"|"dotnetcore1.0"|"dotnetcore2.0"|"dotnetcore2.1"|"dotnetcore3.1"|"nodejs4.3-edge"|"go1.x"|"ruby2.5"|"ruby2.7"|"provided"|"provided.al2"
  ),
  LicenseInfo = "string"
)
}
}

\examples{
\dontrun{
# The following example creates a new Python library layer version. The
# command retrieves the layer content a file named layer.zip in the
# specified S3 bucket.
svc$publish_layer_version(
  CompatibleRuntimes = list(
    "python3.6",
    "python3.7"
  ),
  Content = list(
    S3Bucket = "lambda-layers-us-west-2-123456789012",
    S3Key = "layer.zip"
  ),
  Description = "My Python layer",
  LayerName = "my-layer",
  LicenseInfo = "MIT"
)
}

}
\keyword{internal}
