% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_delete_task_set}
\alias{ecs_delete_task_set}
\title{Deletes a specified task set within a service}
\usage{
ecs_delete_task_set(cluster, service, taskSet, force)
}
\arguments{
\item{cluster}{[required] The short name or full Amazon Resource Name (ARN) of the cluster that
hosts the service that the task set exists in to delete.}

\item{service}{[required] The short name or full Amazon Resource Name (ARN) of the service that
hosts the task set to delete.}

\item{taskSet}{[required] The task set ID or full Amazon Resource Name (ARN) of the task set to
delete.}

\item{force}{If \code{true}, this allows you to delete a task set even if it hasn't been
scaled down to zero.}
}
\value{
A list with the following syntax:\preformatted{list(
  taskSet = list(
    id = "string",
    taskSetArn = "string",
    serviceArn = "string",
    clusterArn = "string",
    startedBy = "string",
    externalId = "string",
    status = "string",
    taskDefinition = "string",
    computedDesiredCount = 123,
    pendingCount = 123,
    runningCount = 123,
    createdAt = as.POSIXct(
      "2015-01-01"
    ),
    updatedAt = as.POSIXct(
      "2015-01-01"
    ),
    launchType = "EC2"|"FARGATE",
    capacityProviderStrategy = list(
      list(
        capacityProvider = "string",
        weight = 123,
        base = 123
      )
    ),
    platformVersion = "string",
    networkConfiguration = list(
      awsvpcConfiguration = list(
        subnets = list(
          "string"
        ),
        securityGroups = list(
          "string"
        ),
        assignPublicIp = "ENABLED"|"DISABLED"
      )
    ),
    loadBalancers = list(
      list(
        targetGroupArn = "string",
        loadBalancerName = "string",
        containerName = "string",
        containerPort = 123
      )
    ),
    serviceRegistries = list(
      list(
        registryArn = "string",
        port = 123,
        containerName = "string",
        containerPort = 123
      )
    ),
    scale = list(
      value = 123.0,
      unit = "PERCENT"
    ),
    stabilityStatus = "STEADY_STATE"|"STABILIZING",
    stabilityStatusAt = as.POSIXct(
      "2015-01-01"
    ),
    tags = list(
      list(
        key = "string",
        value = "string"
      )
    )
  )
)
}
}
\description{
Deletes a specified task set within a service. This is used when a
service uses the \code{EXTERNAL} deployment controller type. For more
information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html}{Amazon ECS Deployment Types}
in the \emph{Amazon Elastic Container Service Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$delete_task_set(
  cluster = "string",
  service = "string",
  taskSet = "string",
  force = TRUE|FALSE
)
}
}

\keyword{internal}
