% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_vpn_connection_options}
\alias{ec2_modify_vpn_connection_options}
\title{Modifies the connection options for your Site-to-Site VPN connection}
\usage{
ec2_modify_vpn_connection_options(VpnConnectionId, LocalIpv4NetworkCidr,
  RemoteIpv4NetworkCidr, LocalIpv6NetworkCidr, RemoteIpv6NetworkCidr,
  DryRun)
}
\arguments{
\item{VpnConnectionId}{[required] The ID of the Site-to-Site VPN connection.}

\item{LocalIpv4NetworkCidr}{The IPv4 CIDR on the customer gateway (on-premises) side of the VPN
connection.

Default: \verb{0.0.0.0/0}}

\item{RemoteIpv4NetworkCidr}{The IPv4 CIDR on the AWS side of the VPN connection.

Default: \verb{0.0.0.0/0}}

\item{LocalIpv6NetworkCidr}{The IPv6 CIDR on the customer gateway (on-premises) side of the VPN
connection.

Default: \verb{::/0}}

\item{RemoteIpv6NetworkCidr}{The IPv6 CIDR on the AWS side of the VPN connection.

Default: \verb{::/0}}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\value{
A list with the following syntax:\preformatted{list(
  VpnConnection = list(
    CustomerGatewayConfiguration = "string",
    CustomerGatewayId = "string",
    Category = "string",
    State = "pending"|"available"|"deleting"|"deleted",
    Type = "ipsec.1",
    VpnConnectionId = "string",
    VpnGatewayId = "string",
    TransitGatewayId = "string",
    Options = list(
      EnableAcceleration = TRUE|FALSE,
      StaticRoutesOnly = TRUE|FALSE,
      LocalIpv4NetworkCidr = "string",
      RemoteIpv4NetworkCidr = "string",
      LocalIpv6NetworkCidr = "string",
      RemoteIpv6NetworkCidr = "string",
      TunnelInsideIpVersion = "ipv4"|"ipv6",
      TunnelOptions = list(
        list(
          OutsideIpAddress = "string",
          TunnelInsideCidr = "string",
          TunnelInsideIpv6Cidr = "string",
          PreSharedKey = "string",
          Phase1LifetimeSeconds = 123,
          Phase2LifetimeSeconds = 123,
          RekeyMarginTimeSeconds = 123,
          RekeyFuzzPercentage = 123,
          ReplayWindowSize = 123,
          DpdTimeoutSeconds = 123,
          DpdTimeoutAction = "string",
          Phase1EncryptionAlgorithms = list(
            list(
              Value = "string"
            )
          ),
          Phase2EncryptionAlgorithms = list(
            list(
              Value = "string"
            )
          ),
          Phase1IntegrityAlgorithms = list(
            list(
              Value = "string"
            )
          ),
          Phase2IntegrityAlgorithms = list(
            list(
              Value = "string"
            )
          ),
          Phase1DHGroupNumbers = list(
            list(
              Value = 123
            )
          ),
          Phase2DHGroupNumbers = list(
            list(
              Value = 123
            )
          ),
          IkeVersions = list(
            list(
              Value = "string"
            )
          ),
          StartupAction = "string"
        )
      )
    ),
    Routes = list(
      list(
        DestinationCidrBlock = "string",
        Source = "Static",
        State = "pending"|"available"|"deleting"|"deleted"
      )
    ),
    Tags = list(
      list(
        Key = "string",
        Value = "string"
      )
    ),
    VgwTelemetry = list(
      list(
        AcceptedRouteCount = 123,
        LastStatusChange = as.POSIXct(
          "2015-01-01"
        ),
        OutsideIpAddress = "string",
        Status = "UP"|"DOWN",
        StatusMessage = "string",
        CertificateArn = "string"
      )
    )
  )
)
}
}
\description{
Modifies the connection options for your Site-to-Site VPN connection.

When you modify the VPN connection options, the VPN endpoint IP
addresses on the AWS side do not change, and the tunnel options do not
change. Your VPN connection will be temporarily unavailable for a brief
period while the VPN connection is updated.
}
\section{Request syntax}{
\preformatted{svc$modify_vpn_connection_options(
  VpnConnectionId = "string",
  LocalIpv4NetworkCidr = "string",
  RemoteIpv4NetworkCidr = "string",
  LocalIpv6NetworkCidr = "string",
  RemoteIpv6NetworkCidr = "string",
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
