% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_disable_vpc_classic_link}
\alias{ec2_disable_vpc_classic_link}
\title{Disables ClassicLink for a VPC}
\usage{
ec2_disable_vpc_classic_link(DryRun, VpcId)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{VpcId}{[required] The ID of the VPC.}
}
\value{
A list with the following syntax:\preformatted{list(
  Return = TRUE|FALSE
)
}
}
\description{
Disables ClassicLink for a VPC. You cannot disable ClassicLink for a VPC
that has EC2-Classic instances linked to it.
}
\section{Request syntax}{
\preformatted{svc$disable_vpc_classic_link(
  DryRun = TRUE|FALSE,
  VpcId = "string"
)
}
}

\keyword{internal}
