% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_operations.R
\name{batch_describe_jobs}
\alias{batch_describe_jobs}
\title{Describes a list of AWS Batch jobs}
\usage{
batch_describe_jobs(jobs)
}
\arguments{
\item{jobs}{[required] A list of up to 100 job IDs.}
}
\value{
A list with the following syntax:\preformatted{list(
  jobs = list(
    list(
      jobArn = "string",
      jobName = "string",
      jobId = "string",
      jobQueue = "string",
      status = "SUBMITTED"|"PENDING"|"RUNNABLE"|"STARTING"|"RUNNING"|"SUCCEEDED"|"FAILED",
      attempts = list(
        list(
          container = list(
            containerInstanceArn = "string",
            taskArn = "string",
            exitCode = 123,
            reason = "string",
            logStreamName = "string",
            networkInterfaces = list(
              list(
                attachmentId = "string",
                ipv6Address = "string",
                privateIpv4Address = "string"
              )
            )
          ),
          startedAt = 123,
          stoppedAt = 123,
          statusReason = "string"
        )
      ),
      statusReason = "string",
      createdAt = 123,
      retryStrategy = list(
        attempts = 123,
        evaluateOnExit = list(
          list(
            onStatusReason = "string",
            onReason = "string",
            onExitCode = "string",
            action = "RETRY"|"EXIT"
          )
        )
      ),
      startedAt = 123,
      stoppedAt = 123,
      dependsOn = list(
        list(
          jobId = "string",
          type = "N_TO_N"|"SEQUENTIAL"
        )
      ),
      jobDefinition = "string",
      parameters = list(
        "string"
      ),
      container = list(
        image = "string",
        vcpus = 123,
        memory = 123,
        command = list(
          "string"
        ),
        jobRoleArn = "string",
        executionRoleArn = "string",
        volumes = list(
          list(
            host = list(
              sourcePath = "string"
            ),
            name = "string"
          )
        ),
        environment = list(
          list(
            name = "string",
            value = "string"
          )
        ),
        mountPoints = list(
          list(
            containerPath = "string",
            readOnly = TRUE|FALSE,
            sourceVolume = "string"
          )
        ),
        readonlyRootFilesystem = TRUE|FALSE,
        ulimits = list(
          list(
            hardLimit = 123,
            name = "string",
            softLimit = 123
          )
        ),
        privileged = TRUE|FALSE,
        user = "string",
        exitCode = 123,
        reason = "string",
        containerInstanceArn = "string",
        taskArn = "string",
        logStreamName = "string",
        instanceType = "string",
        networkInterfaces = list(
          list(
            attachmentId = "string",
            ipv6Address = "string",
            privateIpv4Address = "string"
          )
        ),
        resourceRequirements = list(
          list(
            value = "string",
            type = "GPU"|"VCPU"|"MEMORY"
          )
        ),
        linuxParameters = list(
          devices = list(
            list(
              hostPath = "string",
              containerPath = "string",
              permissions = list(
                "READ"|"WRITE"|"MKNOD"
              )
            )
          ),
          initProcessEnabled = TRUE|FALSE,
          sharedMemorySize = 123,
          tmpfs = list(
            list(
              containerPath = "string",
              size = 123,
              mountOptions = list(
                "string"
              )
            )
          ),
          maxSwap = 123,
          swappiness = 123
        ),
        logConfiguration = list(
          logDriver = "json-file"|"syslog"|"journald"|"gelf"|"fluentd"|"awslogs"|"splunk",
          options = list(
            "string"
          ),
          secretOptions = list(
            list(
              name = "string",
              valueFrom = "string"
            )
          )
        ),
        secrets = list(
          list(
            name = "string",
            valueFrom = "string"
          )
        ),
        networkConfiguration = list(
          assignPublicIp = "ENABLED"|"DISABLED"
        ),
        fargatePlatformConfiguration = list(
          platformVersion = "string"
        )
      ),
      nodeDetails = list(
        nodeIndex = 123,
        isMainNode = TRUE|FALSE
      ),
      nodeProperties = list(
        numNodes = 123,
        mainNode = 123,
        nodeRangeProperties = list(
          list(
            targetNodes = "string",
            container = list(
              image = "string",
              vcpus = 123,
              memory = 123,
              command = list(
                "string"
              ),
              jobRoleArn = "string",
              executionRoleArn = "string",
              volumes = list(
                list(
                  host = list(
                    sourcePath = "string"
                  ),
                  name = "string"
                )
              ),
              environment = list(
                list(
                  name = "string",
                  value = "string"
                )
              ),
              mountPoints = list(
                list(
                  containerPath = "string",
                  readOnly = TRUE|FALSE,
                  sourceVolume = "string"
                )
              ),
              readonlyRootFilesystem = TRUE|FALSE,
              privileged = TRUE|FALSE,
              ulimits = list(
                list(
                  hardLimit = 123,
                  name = "string",
                  softLimit = 123
                )
              ),
              user = "string",
              instanceType = "string",
              resourceRequirements = list(
                list(
                  value = "string",
                  type = "GPU"|"VCPU"|"MEMORY"
                )
              ),
              linuxParameters = list(
                devices = list(
                  list(
                    hostPath = "string",
                    containerPath = "string",
                    permissions = list(
                      "READ"|"WRITE"|"MKNOD"
                    )
                  )
                ),
                initProcessEnabled = TRUE|FALSE,
                sharedMemorySize = 123,
                tmpfs = list(
                  list(
                    containerPath = "string",
                    size = 123,
                    mountOptions = list(
                      "string"
                    )
                  )
                ),
                maxSwap = 123,
                swappiness = 123
              ),
              logConfiguration = list(
                logDriver = "json-file"|"syslog"|"journald"|"gelf"|"fluentd"|"awslogs"|"splunk",
                options = list(
                  "string"
                ),
                secretOptions = list(
                  list(
                    name = "string",
                    valueFrom = "string"
                  )
                )
              ),
              secrets = list(
                list(
                  name = "string",
                  valueFrom = "string"
                )
              ),
              networkConfiguration = list(
                assignPublicIp = "ENABLED"|"DISABLED"
              ),
              fargatePlatformConfiguration = list(
                platformVersion = "string"
              )
            )
          )
        )
      ),
      arrayProperties = list(
        statusSummary = list(
          123
        ),
        size = 123,
        index = 123
      ),
      timeout = list(
        attemptDurationSeconds = 123
      ),
      tags = list(
        "string"
      ),
      propagateTags = TRUE|FALSE,
      platformCapabilities = list(
        "EC2"|"FARGATE"
      )
    )
  )
)
}
}
\description{
Describes a list of AWS Batch jobs.
}
\section{Request syntax}{
\preformatted{svc$describe_jobs(
  jobs = list(
    "string"
  )
)
}
}

\examples{
\dontrun{
# This example describes a job with the specified job ID.
svc$describe_jobs(
  jobs = list(
    "24fa2d7a-64c4-49d2-8b47-f8da4fbde8e9"
  )
)
}

}
\keyword{internal}
