% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_start_network_insights_analysis}
\alias{ec2_start_network_insights_analysis}
\title{Starts analyzing the specified path}
\usage{
ec2_start_network_insights_analysis(NetworkInsightsPathId, FilterInArns,
  DryRun, TagSpecifications, ClientToken)
}
\arguments{
\item{NetworkInsightsPathId}{[required] The ID of the path.}

\item{FilterInArns}{The Amazon Resource Names (ARN) of the resources that the path must
traverse.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{TagSpecifications}{The tags to apply.}

\item{ClientToken}{[required] Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{How to Ensure Idempotency}.}
}
\description{
Starts analyzing the specified path. If the path is reachable, the
operation returns the shortest feasible path.
}
\section{Request syntax}{
\preformatted{svc$start_network_insights_analysis(
  NetworkInsightsPathId = "string",
  FilterInArns = list(
    "string"
  ),
  DryRun = TRUE|FALSE,
  TagSpecifications = list(
    list(
      ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
      Tags = list(
        list(
          Key = "string",
          Value = "string"
        )
      )
    )
  ),
  ClientToken = "string"
)
}
}

\keyword{internal}
