% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_purchase_scheduled_instances}
\alias{ec2_purchase_scheduled_instances}
\title{Purchases the Scheduled Instances with the specified schedule}
\usage{
ec2_purchase_scheduled_instances(ClientToken, DryRun, PurchaseRequests)
}
\arguments{
\item{ClientToken}{Unique, case-sensitive identifier that ensures the idempotency of the
request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{Ensuring Idempotency}.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{PurchaseRequests}{[required] The purchase requests.}
}
\description{
Purchases the Scheduled Instances with the specified schedule.

Scheduled Instances enable you to purchase Amazon EC2 compute capacity
by the hour for a one-year term. Before you can purchase a Scheduled
Instance, you must call DescribeScheduledInstanceAvailability to check
for available schedules and obtain a purchase token. After you purchase
a Scheduled Instance, you must call RunScheduledInstances during each
scheduled time period.

After you purchase a Scheduled Instance, you can't cancel, modify, or
resell your purchase.
}
\section{Request syntax}{
\preformatted{svc$purchase_scheduled_instances(
  ClientToken = "string",
  DryRun = TRUE|FALSE,
  PurchaseRequests = list(
    list(
      InstanceCount = 123,
      PurchaseToken = "string"
    )
  )
)
}
}

\examples{
\dontrun{
# This example purchases a Scheduled Instance.
svc$purchase_scheduled_instances(
  PurchaseRequests = list(
    list(
      InstanceCount = 1L,
      PurchaseToken = "eyJ2IjoiMSIsInMiOjEsImMiOi..."
    )
  )
)
}

}
\keyword{internal}
