% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_move_address_to_vpc}
\alias{ec2_move_address_to_vpc}
\title{Moves an Elastic IP address from the EC2-Classic platform to the EC2-VPC
platform}
\usage{
ec2_move_address_to_vpc(DryRun, PublicIp)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{PublicIp}{[required] The Elastic IP address.}
}
\description{
Moves an Elastic IP address from the EC2-Classic platform to the EC2-VPC
platform. The Elastic IP address must be allocated to your account for
more than 24 hours, and it must not be associated with an instance.
After the Elastic IP address is moved, it is no longer available for use
in the EC2-Classic platform, unless you move it back using the
RestoreAddressToClassic request. You cannot move an Elastic IP address
that was originally allocated for use in the EC2-VPC platform to the
EC2-Classic platform.
}
\section{Request syntax}{
\preformatted{svc$move_address_to_vpc(
  DryRun = TRUE|FALSE,
  PublicIp = "string"
)
}
}

\examples{
\dontrun{
# This example moves the specified Elastic IP address to the EC2-VPC
# platform.
svc$move_address_to_vpc(
  PublicIp = "54.123.4.56"
)
}

}
\keyword{internal}
