% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_volumes}
\alias{ec2_describe_volumes}
\title{Describes the specified EBS volumes or all of your EBS volumes}
\usage{
ec2_describe_volumes(Filters, VolumeIds, DryRun, MaxResults, NextToken)
}
\arguments{
\item{Filters}{The filters.
\itemize{
\item \code{attachment.attach-time} - The time stamp when the attachment
initiated.
\item \code{attachment.delete-on-termination} - Whether the volume is deleted
on instance termination.
\item \code{attachment.device} - The device name specified in the block device
mapping (for example, \verb{/dev/sda1}).
\item \code{attachment.instance-id} - The ID of the instance the volume is
attached to.
\item \code{attachment.status} - The attachment state (\code{attaching} | \code{attached}
| \code{detaching}).
\item \code{availability-zone} - The Availability Zone in which the volume was
created.
\item \code{create-time} - The time stamp when the volume was created.
\item \code{encrypted} - Indicates whether the volume is encrypted (\code{true} |
\code{false})
\item \code{multi-attach-enabled} - Indicates whether the volume is enabled for
Multi-Attach (\code{true} | \code{false})
\item \code{fast-restored} - Indicates whether the volume was created from a
snapshot that is enabled for fast snapshot restore (\code{true} |
\code{false}).
\item \code{size} - The size of the volume, in GiB.
\item \code{snapshot-id} - The snapshot from which the volume was created.
\item \code{status} - The state of the volume (\code{creating} | \code{available} |
\verb{in-use} | \code{deleting} | \code{deleted} | \code{error}).
\item \code{tag}:<key> - The key/value combination of a tag assigned to
the resource. Use the tag key in the filter name and the tag value
as the filter value. For example, to find all resources that have a
tag with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner}
for the filter name and \code{TeamA} for the filter value.
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources assigned a tag with a specific key,
regardless of the tag value.
\item \code{volume-id} - The volume ID.
\item \code{volume-type} - The Amazon EBS volume type (\code{gp2} | \code{gp3} | \code{io1} |
\code{io2} | \code{st1} | \code{sc1}| \code{standard})
}}

\item{VolumeIds}{The volume IDs.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{MaxResults}{The maximum number of volume results returned by \code{DescribeVolumes} in
paginated output. When this parameter is used, \code{DescribeVolumes} only
returns \code{MaxResults} results in a single page along with a \code{NextToken}
response element. The remaining results of the initial request can be
seen by sending another \code{DescribeVolumes} request with the returned
\code{NextToken} value. This value can be between 5 and 500; if \code{MaxResults}
is given a value larger than 500, only 500 results are returned. If this
parameter is not used, then \code{DescribeVolumes} returns all results. You
cannot specify this parameter and the volume IDs parameter in the same
request.}

\item{NextToken}{The \code{NextToken} value returned from a previous paginated
\code{DescribeVolumes} request where \code{MaxResults} was used and the results
exceeded the value of that parameter. Pagination continues from the end
of the previous results that returned the \code{NextToken} value. This value
is \code{null} when there are no more results to return.}
}
\description{
Describes the specified EBS volumes or all of your EBS volumes.

If you are describing a long list of volumes, we recommend that you
paginate the output to make the list more manageable. The \code{MaxResults}
parameter sets the maximum number of results returned in a single page.
If the list of results exceeds your \code{MaxResults} value, then that number
of results is returned along with a \code{NextToken} value that can be passed
to a subsequent \code{DescribeVolumes} request to retrieve the remaining
results.

For more information about EBS volumes, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-volumes.html}{Amazon EBS volumes}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$describe_volumes(
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  VolumeIds = list(
    "string"
  ),
  DryRun = TRUE|FALSE,
  MaxResults = 123,
  NextToken = "string"
)
}
}

\examples{
\dontrun{
# This example describes all of your volumes in the default region.
svc$describe_volumes()

# This example describes all volumes that are both attached to the
# instance with the ID i-1234567890abcdef0 and set to delete when the
# instance terminates.
svc$describe_volumes(
  Filters = list(
    list(
      Name = "attachment.instance-id",
      Values = list(
        "i-1234567890abcdef0"
      )
    ),
    list(
      Name = "attachment.delete-on-termination",
      Values = list(
        "true"
      )
    )
  )
)
}

}
\keyword{internal}
