################################################################
# Generated by make.paws: do not edit by hand
# Please edit: make.paws/inst/templates/set_service_parameter.R
################################################################

#' @title Set service parameters
#' @description
#' Help functions for setting the parameters for services
#'
#' @param credentials \code{credentials()} or \code{list} in same format.
#' \itemize{
#' \item{\strong{creds}: \code{creds()} or \code{list} in same format.
#' \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' \item{\strong{access_token}: The token issued by the \code{CreateToken} API call. For more information, see
#' \href{https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/API_CreateToken.html}{CreateToken}
#' in the `IAM Identity Center OIDC API Reference Guide`.}
#' \item{\strong{expiration}: The date and time when the temporary credentials expire.
#' `expiration` must be a `POSIXct` date-time or able to be compared with them.}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param endpoint The complete URL to use for the constructed client.
#' @param region The AWS Region used in instantiating the client.
#' @param close_connection Immediately close all HTTP connections.
#' @param connect_timeout The time in seconds till a timeout exception is thrown
#' when attempting to make a connection. The default is 60 seconds.
#' @param max_retries Max number of retries call AWS API (default set to 3).
#' @param s3_force_path_style Set this to `true` to force the request to use path-style
#' addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.
#' @param sts_regional_endpoint Set sts regional endpoint resolver to regional or
#' legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}
#' @param signature_version The signature version used when signing requests.
#' Note that the default version is Signature Version 4.
#' @param creds \code{creds()} or \code{list} in same format.
#' \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' \item{\strong{access_token}: The token issued by the \code{CreateToken} API call. For more information, see
#' \href{https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/API_CreateToken.html}{CreateToken}
#' in the `IAM Identity Center OIDC API Reference Guide`.}
#' \item{\strong{expiration}: The date and time when the temporary credentials expire.
#' `expiration` must be a `POSIXct` date-time or able to be compared with them.}
#' }
#' @param profile The name of a profile to use. If not given, then the default profile is used.
#' @param anonymous Set anonymous credentials.
#' @param access_key_id AWS access key ID
#' @param secret_access_key AWS secret access key
#' @param session_token AWS temporary session token
#' @param access_token The token issued by the \code{CreateToken} API call. For more information, see
#' \href{https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/API_CreateToken.html}{CreateToken}
#' in the `IAM Identity Center OIDC API Reference Guide`.
#' @param expiration The date and time when the temporary credentials expire.
#' `expiration` must be a `POSIXct` date-time or able to be compared with them.
#' @return list set of parameter variables for paws services.
#' @examples
#' # set service parameter access_key_id and secret_access_key
#'
#' config(credentials(creds("dummy", "secret")))
#'
#' # set service parameter access_key_id and secret_access_key using using lists
#' config(
#'     credentials = list(
#'         creds = list(
#'             access_key_id = "dummy",
#'             secret_access_key = "secret"
#'         )
#'     )
#' )
#'
#' @name set_service_parameter
#' @export
config <- function (credentials = list(creds = list(access_key_id = "", 
    secret_access_key = "", session_token = "", access_token = "", 
    expiration = Inf), profile = "", anonymous = FALSE), endpoint = "", 
    region = "", close_connection = FALSE, max_retries = 3, connect_timeout = 60, 
    s3_force_path_style = FALSE, sts_regional_endpoint = "", 
    signature_version = "") 
{
    .args <- as.list(environment(), all.names = TRUE)
    class(.args) <- "struct"
    return(.args)
}

#' @rdname set_service_parameter
#' @export
credentials <- function (creds = list(access_key_id = "", secret_access_key = "", 
    session_token = "", access_token = "", expiration = Inf), 
    profile = "", anonymous = FALSE) 
{
    .args <- as.list(environment(), all.names = TRUE)
    class(.args) <- "struct"
    return(.args)
}

#' @rdname set_service_parameter
#' @export
creds <- function (access_key_id = "", secret_access_key = "", session_token = "", 
    access_token = "", expiration = Inf) 
{
    .args <- as.list(environment(), all.names = TRUE)
    class(.args) <- "struct"
    return(.args)
}
