% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eventbridge_operations.R
\name{eventbridge_create_event_bus}
\alias{eventbridge_create_event_bus}
\title{Creates a new event bus within your account}
\usage{
eventbridge_create_event_bus(Name, EventSourceName = NULL, Tags = NULL)
}
\arguments{
\item{Name}{[required] The name of the new event bus.

Custom event bus names can't contain the \code{/} character, but you can use
the \code{/} character in partner event bus names. In addition, for partner
event buses, the name must exactly match the name of the partner event
source that this event bus is matched to.

You can't use the name \code{default} for a custom event bus, as this name is
already used for your account's default event bus.}

\item{EventSourceName}{If you are creating a partner event bus, this specifies the partner
event source that the new event bus will be matched with.}

\item{Tags}{Tags to associate with the event bus.}
}
\description{
Creates a new event bus within your account. This can be a custom event bus which you can use to receive events from your custom applications and services, or it can be a partner event bus which can be matched to a partner event source.

See \url{https://www.paws-r-sdk.com/docs/eventbridge_create_event_bus/} for full documentation.
}
\keyword{internal}
