% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locationservice_operations.R
\name{locationservice_get_map_glyphs}
\alias{locationservice_get_map_glyphs}
\title{Retrieves glyphs used to display labels on a map}
\usage{
locationservice_get_map_glyphs(FontStack, FontUnicodeRange, MapName)
}
\arguments{
\item{FontStack}{[required] A comma-separated list of fonts to load glyphs from in order of
preference. For example, \verb{Noto Sans Regular, Arial Unicode}.

Valid fonts stacks for
\href{https://docs.aws.amazon.com/location/latest/developerguide/esri.html}{Esri}
styles:
\itemize{
\item VectorEsriDarkGrayCanvas – \verb{Ubuntu Medium Italic} | \verb{Ubuntu Medium}
| \verb{Ubuntu Italic} | \verb{Ubuntu Regular} | \verb{Ubuntu Bold}
\item VectorEsriLightGrayCanvas – \verb{Ubuntu Italic} | \verb{Ubuntu Regular} |
\verb{Ubuntu Light} | \verb{Ubuntu Bold}
\item VectorEsriTopographic – \verb{Noto Sans Italic} | \verb{Noto Sans Regular} |
\verb{Noto Sans Bold} | \verb{Noto Serif Regular} |
\verb{Roboto Condensed Light Italic}
\item VectorEsriStreets – \verb{Arial Regular} | \verb{Arial Italic} | \verb{Arial Bold}
\item VectorEsriNavigation – \verb{Arial Regular} | \verb{Arial Italic} |
\verb{Arial Bold}
}

Valid font stacks for \href{https://docs.aws.amazon.com/location/latest/developerguide/HERE.html}{HERE Technologies}
styles:
\itemize{
\item VectorHereContrast – \verb{Fira GO Regular} | \verb{Fira GO Bold}
\item VectorHereExplore, VectorHereExploreTruck – \verb{Firo GO Italic} |
\verb{Fira GO Map} | \verb{Fira GO Map Bold} | \verb{Noto Sans CJK JP Bold} |
\verb{Noto Sans CJK JP Light} | \verb{Noto Sans CJK JP Regular}
}}

\item{FontUnicodeRange}{[required] A Unicode range of characters to download glyphs for. Each response will
contain 256 characters. For example, 0–255 includes all characters from
range \code{U+0000} to \verb{00FF}. Must be aligned to multiples of 256.}

\item{MapName}{[required] The map resource associated with the glyph ﬁle.}
}
\description{
Retrieves glyphs used to display labels on a map.

See \url{https://paws-r.github.io/docs/locationservice/get_map_glyphs.html} for full documentation.
}
\keyword{internal}
