% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eventbridge_operations.R
\name{eventbridge_update_endpoint}
\alias{eventbridge_update_endpoint}
\title{Update an existing endpoint}
\usage{
eventbridge_update_endpoint(
  Name,
  Description = NULL,
  RoutingConfig = NULL,
  ReplicationConfig = NULL,
  EventBuses = NULL,
  RoleArn = NULL
)
}
\arguments{
\item{Name}{[required] The name of the endpoint you want to update.}

\item{Description}{A description for the endpoint.}

\item{RoutingConfig}{Configure the routing policy, including the health check and secondary
Region..}

\item{ReplicationConfig}{Whether event replication was enabled or disabled by this request.}

\item{EventBuses}{Define event buses used for replication.}

\item{RoleArn}{The ARN of the role used by event replication for this request.}
}
\description{
Update an existing endpoint. For more information about global endpoints, see \href{https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-global-endpoints.html}{Making applications Regional-fault tolerant with global endpoints and event replication} in the Amazon EventBridge User Guide..

See \url{https://paws-r.github.io/docs/eventbridge/update_endpoint.html} for full documentation.
}
\keyword{internal}
