% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swf_operations.R
\name{swf_poll_for_decision_task}
\alias{swf_poll_for_decision_task}
\title{Used by deciders to get a DecisionTask from the specified decision
taskList}
\usage{
swf_poll_for_decision_task(domain, taskList, identity, nextPageToken,
  maximumPageSize, reverseOrder)
}
\arguments{
\item{domain}{[required] The name of the domain containing the task lists to poll.}

\item{taskList}{[required] Specifies the task list to poll for decision tasks.

The specified string must not start or end with whitespace. It must not
contain a \code{:} (colon), \code{/} (slash), \code{|} (vertical bar), or any control
characters (\verb{U+0000`-`U+001f} \\| \verb{U+007f`-`U+009f}). Also, it must not \emph{be}
the literal string \code{arn}.}

\item{identity}{Identity of the decider making the request, which is recorded in the
DecisionTaskStarted event in the workflow history. This enables
diagnostic tracing when problems arise. The form of this identity is
user defined.}

\item{nextPageToken}{If \code{NextPageToken} is returned there are more results available. The
value of \code{NextPageToken} is a unique pagination token for each page.
Make the call again using the returned token to retrieve the next page.
Keep all other arguments unchanged. Each pagination token expires after
60 seconds. Using an expired pagination token will return a \code{400} error:
\"\verb{Specified token has exceeded its maximum lifetime}\".

The configured \code{maximumPageSize} determines how many results can be
returned in a single call.

The \code{nextPageToken} returned by this action cannot be used with
GetWorkflowExecutionHistory to get the next page. You must call
PollForDecisionTask again (with the \code{nextPageToken}) to retrieve the
next page of history records. Calling PollForDecisionTask with a
\code{nextPageToken} doesn\'t return a new decision task.}

\item{maximumPageSize}{The maximum number of results that are returned per call. Use
\code{nextPageToken} to obtain further pages of results.

This is an upper limit only; the actual number of results returned per
call may be fewer than the specified maximum.}

\item{reverseOrder}{When set to \code{true}, returns the events in reverse order. By default the
results are returned in ascending order of the \code{eventTimestamp} of the
events.}
}
\description{
Used by deciders to get a DecisionTask from the specified decision
\code{taskList}. A decision task may be returned for any open workflow
execution that is using the specified task list. The task includes a
paginated view of the history of the workflow execution. The decider
should use the workflow type and the history to determine how to
properly handle the task.
}
\details{
This action initiates a long poll, where the service holds the HTTP
connection open and responds as soon a task becomes available. If no
decision task is available in the specified task list before the timeout
of 60 seconds expires, an empty result is returned. An empty result, in
this context, means that a DecisionTask is returned, but that the value
of taskToken is an empty string.

Deciders should set their client side socket timeout to at least 70
seconds (10 seconds higher than the timeout).

Because the number of workflow history events for a single workflow
execution might be very large, the result returned might be split up
across a number of pages. To retrieve subsequent pages, make additional
calls to \code{PollForDecisionTask} using the \code{nextPageToken} returned by the
initial call. Note that you do \emph{not} call \code{GetWorkflowExecutionHistory}
with this \code{nextPageToken}. Instead, call \code{PollForDecisionTask} again.

\strong{Access Control}

You can use IAM policies to control this action\'s access to Amazon SWF
resources as follows:
\itemize{
\item Use a \code{Resource} element with the domain name to limit the action to
only specified domains.
\item Use an \code{Action} element to allow or deny permission to call this
action.
\item Constrain the \code{taskList.name} parameter by using a \code{Condition}
element with the \code{swf:taskList.name} key to allow the action to
access only certain task lists.
}

If the caller doesn\'t have sufficient permissions to invoke the action,
or the parameter values fall outside the specified constraints, the
action fails. The associated event attribute\'s \code{cause} parameter is set
to \code{OPERATION_NOT_PERMITTED}. For details and example IAM policies, see
\href{https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html}{Using IAM to Manage Access to Amazon SWF Workflows}
in the \emph{Amazon SWF Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$poll_for_decision_task(
  domain = "string",
  taskList = list(
    name = "string"
  ),
  identity = "string",
  nextPageToken = "string",
  maximumPageSize = 123,
  reverseOrder = TRUE|FALSE
)
}
}

\keyword{internal}
