% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sqs_operations.R
\name{sqs_change_message_visibility_batch}
\alias{sqs_change_message_visibility_batch}
\title{Changes the visibility timeout of multiple messages}
\usage{
sqs_change_message_visibility_batch(QueueUrl, Entries)
}
\arguments{
\item{QueueUrl}{[required] The URL of the Amazon SQS queue whose messages' visibility is changed.

Queue URLs and names are case-sensitive.}

\item{Entries}{[required] A list of receipt handles of the messages for which the visibility
timeout must be changed.}
}
\value{
A list with the following syntax:\preformatted{list(
  Successful = list(
    list(
      Id = "string"
    )
  ),
  Failed = list(
    list(
      Id = "string",
      SenderFault = TRUE|FALSE,
      Code = "string",
      Message = "string"
    )
  )
)
}
}
\description{
Changes the visibility timeout of multiple messages. This is a batch
version of \code{ ChangeMessageVisibility.} The result of the action on each
message is reported individually in the response. You can send up to 10
\code{\link[=sqs_change_message_visibility]{change_message_visibility}} requests
with each
\code{\link[=sqs_change_message_visibility_batch]{change_message_visibility_batch}}
action.

Because the batch request can result in a combination of successful and
unsuccessful actions, you should check for batch errors even when the
call returns an HTTP status code of \code{200}.

Some actions take lists of parameters. These lists are specified using
the \code{param.n} notation. Values of \code{n} are integers starting from 1. For
example, a parameter list with two elements looks like this:

\verb{&AttributeName.1=first}

\verb{&AttributeName.2=second}
}
\section{Request syntax}{
\preformatted{svc$change_message_visibility_batch(
  QueueUrl = "string",
  Entries = list(
    list(
      Id = "string",
      ReceiptHandle = "string",
      VisibilityTimeout = 123
    )
  )
)
}
}

\keyword{internal}
