% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eventbridge_operations.R
\name{eventbridge_list_archives}
\alias{eventbridge_list_archives}
\title{Lists your archives}
\usage{
eventbridge_list_archives(NamePrefix, EventSourceArn, State, NextToken,
  Limit)
}
\arguments{
\item{NamePrefix}{A name prefix to filter the archives returned. Only archives with name
that match the prefix are returned.}

\item{EventSourceArn}{The ARN of the event source associated with the archive.}

\item{State}{The state of the archive.}

\item{NextToken}{The token returned by a previous call to retrieve the next set of
results.}

\item{Limit}{The maximum number of results to return.}
}
\value{
A list with the following syntax:\preformatted{list(
  Archives = list(
    list(
      ArchiveName = "string",
      EventSourceArn = "string",
      State = "ENABLED"|"DISABLED"|"CREATING"|"UPDATING"|"CREATE_FAILED"|"UPDATE_FAILED",
      StateReason = "string",
      RetentionDays = 123,
      SizeBytes = 123,
      EventCount = 123,
      CreationTime = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Lists your archives. You can either list all the archives or you can
provide a prefix to match to the archive names. Filter parameters are
exclusive.
}
\section{Request syntax}{
\preformatted{svc$list_archives(
  NamePrefix = "string",
  EventSourceArn = "string",
  State = "ENABLED"|"DISABLED"|"CREATING"|"UPDATING"|"CREATE_FAILED"|"UPDATE_FAILED",
  NextToken = "string",
  Limit = 123
)
}
}

\keyword{internal}
