% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_get_table_version}
\alias{glue_get_table_version}
\title{Retrieves a specified version of a table}
\usage{
glue_get_table_version(
  CatalogId = NULL,
  DatabaseName,
  TableName,
  VersionId = NULL
)
}
\arguments{
\item{CatalogId}{The ID of the Data Catalog where the tables reside. If none is provided,
the Amazon Web Services account ID is used by default.}

\item{DatabaseName}{[required] The database in the catalog in which the table resides. For Hive
compatibility, this name is entirely lowercase.}

\item{TableName}{[required] The name of the table. For Hive compatibility, this name is entirely
lowercase.}

\item{VersionId}{The ID value of the table version to be retrieved. A \code{VersionID} is a
string representation of an integer. Each version is incremented by 1.}
}
\description{
Retrieves a specified version of a table.

See \url{https://www.paws-r-sdk.com/docs/glue_get_table_version/} for full documentation.
}
\keyword{internal}
