% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_get_ml_task_runs}
\alias{glue_get_ml_task_runs}
\title{Gets a list of runs for a machine learning transform}
\usage{
glue_get_ml_task_runs(
  TransformId,
  NextToken = NULL,
  MaxResults = NULL,
  Filter = NULL,
  Sort = NULL
)
}
\arguments{
\item{TransformId}{[required] The unique identifier of the machine learning transform.}

\item{NextToken}{A token for pagination of the results. The default is empty.}

\item{MaxResults}{The maximum number of results to return.}

\item{Filter}{The filter criteria, in the \code{TaskRunFilterCriteria} structure, for the
task run.}

\item{Sort}{The sorting criteria, in the \code{TaskRunSortCriteria} structure, for the
task run.}
}
\description{
Gets a list of runs for a machine learning transform. Machine learning task runs are asynchronous tasks that Glue runs on your behalf as part of various machine learning workflows. You can get a sortable, filterable list of machine learning task runs by calling \code{\link[=glue_get_ml_task_runs]{get_ml_task_runs}} with their parent transform's \code{TransformID} and other optional parameters as documented in this section.

See \url{https://www.paws-r-sdk.com/docs/glue_get_ml_task_runs/} for full documentation.
}
\keyword{internal}
