# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include kinesisanalyticsv2_service.R
NULL

#' Adds an Amazon CloudWatch log stream to monitor application
#' configuration errors
#'
#' @description
#' Adds an Amazon CloudWatch log stream to monitor application configuration errors.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_add_application_cloud_watch_logging_option/](https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_add_application_cloud_watch_logging_option/) for full documentation.
#'
#' @param ApplicationName &#91;required&#93; The Kinesis Data Analytics application name.
#' @param CurrentApplicationVersionId The version ID of the SQL-based Kinesis Data Analytics application. You
#' must provide the `CurrentApplicationVersionId` or the
#' `ConditionalToken`.You can retrieve the application version ID using
#' [`describe_application`][kinesisanalyticsv2_describe_application]. For
#' better concurrency support, use the `ConditionalToken` parameter instead
#' of `CurrentApplicationVersionId`.
#' @param CloudWatchLoggingOption &#91;required&#93; Provides the Amazon CloudWatch log stream Amazon Resource Name (ARN).
#' @param ConditionalToken A value you use to implement strong concurrency for application updates.
#' You must provide the `CurrentApplicationVersionId` or the
#' `ConditionalToken`. You get the application's current `ConditionalToken`
#' using [`describe_application`][kinesisanalyticsv2_describe_application].
#' For better concurrency support, use the `ConditionalToken` parameter
#' instead of `CurrentApplicationVersionId`.
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_add_appli_cloud_watch_loggi_optio
kinesisanalyticsv2_add_application_cloud_watch_logging_option <- function(ApplicationName, CurrentApplicationVersionId = NULL, CloudWatchLoggingOption, ConditionalToken = NULL) {
  op <- new_operation(
    name = "AddApplicationCloudWatchLoggingOption",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$add_application_cloud_watch_logging_option_input(ApplicationName = ApplicationName, CurrentApplicationVersionId = CurrentApplicationVersionId, CloudWatchLoggingOption = CloudWatchLoggingOption, ConditionalToken = ConditionalToken)
  output <- .kinesisanalyticsv2$add_application_cloud_watch_logging_option_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$add_application_cloud_watch_logging_option <- kinesisanalyticsv2_add_application_cloud_watch_logging_option

#' Adds a streaming source to your SQL-based Kinesis Data Analytics
#' application
#'
#' @description
#' Adds a streaming source to your SQL-based Kinesis Data Analytics application.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_add_application_input/](https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_add_application_input/) for full documentation.
#'
#' @param ApplicationName &#91;required&#93; The name of your existing application to which you want to add the
#' streaming source.
#' @param CurrentApplicationVersionId &#91;required&#93; The current version of your application. You must provide the
#' `ApplicationVersionID` or the `ConditionalToken`.You can use the
#' [`describe_application`][kinesisanalyticsv2_describe_application]
#' operation to find the current application version.
#' @param Input &#91;required&#93; The Input to add.
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_add_application_input
kinesisanalyticsv2_add_application_input <- function(ApplicationName, CurrentApplicationVersionId, Input) {
  op <- new_operation(
    name = "AddApplicationInput",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$add_application_input_input(ApplicationName = ApplicationName, CurrentApplicationVersionId = CurrentApplicationVersionId, Input = Input)
  output <- .kinesisanalyticsv2$add_application_input_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$add_application_input <- kinesisanalyticsv2_add_application_input

#' Adds an InputProcessingConfiguration to a SQL-based Kinesis Data
#' Analytics application
#'
#' @description
#' Adds an InputProcessingConfiguration to a SQL-based Kinesis Data Analytics application. An input processor pre-processes records on the input stream before the application's SQL code executes. Currently, the only input processor available is [Amazon Lambda](https://docs.aws.amazon.com/lambda/).
#'
#' See [https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_add_application_input_processing_configuration/](https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_add_application_input_processing_configuration/) for full documentation.
#'
#' @param ApplicationName &#91;required&#93; The name of the application to which you want to add the input
#' processing configuration.
#' @param CurrentApplicationVersionId &#91;required&#93; The version of the application to which you want to add the input
#' processing configuration. You can use the
#' [`describe_application`][kinesisanalyticsv2_describe_application]
#' operation to get the current application version. If the version
#' specified is not the current version, the
#' `ConcurrentModificationException` is returned.
#' @param InputId &#91;required&#93; The ID of the input configuration to add the input processing
#' configuration to. You can get a list of the input IDs for an application
#' using the
#' [`describe_application`][kinesisanalyticsv2_describe_application]
#' operation.
#' @param InputProcessingConfiguration &#91;required&#93; The InputProcessingConfiguration to add to the application.
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_add_applic_input_proces_config
kinesisanalyticsv2_add_application_input_processing_configuration <- function(ApplicationName, CurrentApplicationVersionId, InputId, InputProcessingConfiguration) {
  op <- new_operation(
    name = "AddApplicationInputProcessingConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$add_application_input_processing_configuration_input(ApplicationName = ApplicationName, CurrentApplicationVersionId = CurrentApplicationVersionId, InputId = InputId, InputProcessingConfiguration = InputProcessingConfiguration)
  output <- .kinesisanalyticsv2$add_application_input_processing_configuration_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$add_application_input_processing_configuration <- kinesisanalyticsv2_add_application_input_processing_configuration

#' Adds an external destination to your SQL-based Kinesis Data Analytics
#' application
#'
#' @description
#' Adds an external destination to your SQL-based Kinesis Data Analytics application.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_add_application_output/](https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_add_application_output/) for full documentation.
#'
#' @param ApplicationName &#91;required&#93; The name of the application to which you want to add the output
#' configuration.
#' @param CurrentApplicationVersionId &#91;required&#93; The version of the application to which you want to add the output
#' configuration. You can use the
#' [`describe_application`][kinesisanalyticsv2_describe_application]
#' operation to get the current application version. If the version
#' specified is not the current version, the
#' `ConcurrentModificationException` is returned.
#' @param Output &#91;required&#93; An array of objects, each describing one output configuration. In the
#' output configuration, you specify the name of an in-application stream,
#' a destination (that is, a Kinesis data stream, a Kinesis Data Firehose
#' delivery stream, or an Amazon Lambda function), and record the formation
#' to use when writing to the destination.
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_add_application_output
kinesisanalyticsv2_add_application_output <- function(ApplicationName, CurrentApplicationVersionId, Output) {
  op <- new_operation(
    name = "AddApplicationOutput",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$add_application_output_input(ApplicationName = ApplicationName, CurrentApplicationVersionId = CurrentApplicationVersionId, Output = Output)
  output <- .kinesisanalyticsv2$add_application_output_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$add_application_output <- kinesisanalyticsv2_add_application_output

#' Adds a reference data source to an existing SQL-based Kinesis Data
#' Analytics application
#'
#' @description
#' Adds a reference data source to an existing SQL-based Kinesis Data Analytics application.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_add_application_reference_data_source/](https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_add_application_reference_data_source/) for full documentation.
#'
#' @param ApplicationName &#91;required&#93; The name of an existing application.
#' @param CurrentApplicationVersionId &#91;required&#93; The version of the application for which you are adding the reference
#' data source. You can use the
#' [`describe_application`][kinesisanalyticsv2_describe_application]
#' operation to get the current application version. If the version
#' specified is not the current version, the
#' `ConcurrentModificationException` is returned.
#' @param ReferenceDataSource &#91;required&#93; The reference data source can be an object in your Amazon S3 bucket.
#' Kinesis Data Analytics reads the object and copies the data into the
#' in-application table that is created. You provide an S3 bucket, object
#' key name, and the resulting in-application table that is created.
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_add_application_reference_data_source
kinesisanalyticsv2_add_application_reference_data_source <- function(ApplicationName, CurrentApplicationVersionId, ReferenceDataSource) {
  op <- new_operation(
    name = "AddApplicationReferenceDataSource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$add_application_reference_data_source_input(ApplicationName = ApplicationName, CurrentApplicationVersionId = CurrentApplicationVersionId, ReferenceDataSource = ReferenceDataSource)
  output <- .kinesisanalyticsv2$add_application_reference_data_source_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$add_application_reference_data_source <- kinesisanalyticsv2_add_application_reference_data_source

#' Adds a Virtual Private Cloud (VPC) configuration to the application
#'
#' @description
#' Adds a Virtual Private Cloud (VPC) configuration to the application. Applications can use VPCs to store and access resources securely.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_add_application_vpc_configuration/](https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_add_application_vpc_configuration/) for full documentation.
#'
#' @param ApplicationName &#91;required&#93; The name of an existing application.
#' @param CurrentApplicationVersionId The version of the application to which you want to add the VPC
#' configuration. You must provide the `CurrentApplicationVersionId` or the
#' `ConditionalToken`. You can use the
#' [`describe_application`][kinesisanalyticsv2_describe_application]
#' operation to get the current application version. If the version
#' specified is not the current version, the
#' `ConcurrentModificationException` is returned. For better concurrency
#' support, use the `ConditionalToken` parameter instead of
#' `CurrentApplicationVersionId`.
#' @param VpcConfiguration &#91;required&#93; Description of the VPC to add to the application.
#' @param ConditionalToken A value you use to implement strong concurrency for application updates.
#' You must provide the `ApplicationVersionID` or the `ConditionalToken`.
#' You get the application's current `ConditionalToken` using
#' [`describe_application`][kinesisanalyticsv2_describe_application]. For
#' better concurrency support, use the `ConditionalToken` parameter instead
#' of `CurrentApplicationVersionId`.
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_add_application_vpc_configuration
kinesisanalyticsv2_add_application_vpc_configuration <- function(ApplicationName, CurrentApplicationVersionId = NULL, VpcConfiguration, ConditionalToken = NULL) {
  op <- new_operation(
    name = "AddApplicationVpcConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$add_application_vpc_configuration_input(ApplicationName = ApplicationName, CurrentApplicationVersionId = CurrentApplicationVersionId, VpcConfiguration = VpcConfiguration, ConditionalToken = ConditionalToken)
  output <- .kinesisanalyticsv2$add_application_vpc_configuration_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$add_application_vpc_configuration <- kinesisanalyticsv2_add_application_vpc_configuration

#' Creates a Managed Service for Apache Flink application
#'
#' @description
#' Creates a Managed Service for Apache Flink application. For information about creating a Managed Service for Apache Flink application, see [Creating an Application](https://docs.aws.amazon.com/managed-flink/latest/java/getting-started.html).
#'
#' See [https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_create_application/](https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_create_application/) for full documentation.
#'
#' @param ApplicationName &#91;required&#93; The name of your application (for example, `sample-app`).
#' @param ApplicationDescription A summary description of the application.
#' @param RuntimeEnvironment &#91;required&#93; The runtime environment for the application.
#' @param ServiceExecutionRole &#91;required&#93; The IAM role used by the application to access Kinesis data streams,
#' Kinesis Data Firehose delivery streams, Amazon S3 objects, and other
#' external resources.
#' @param ApplicationConfiguration Use this parameter to configure the application.
#' @param CloudWatchLoggingOptions Use this parameter to configure an Amazon CloudWatch log stream to
#' monitor application configuration errors.
#' @param Tags A list of one or more tags to assign to the application. A tag is a
#' key-value pair that identifies an application. Note that the maximum
#' number of application tags includes system tags. The maximum number of
#' user-defined application tags is 50. For more information, see [Using
#' Tagging](https://docs.aws.amazon.com/managed-flink/latest/java/how-tagging.html).
#' @param ApplicationMode Use the `STREAMING` mode to create a Managed Service for Apache Flink
#' application. To create a Managed Service for Apache Flink Studio
#' notebook, use the `INTERACTIVE` mode.
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_create_application
kinesisanalyticsv2_create_application <- function(ApplicationName, ApplicationDescription = NULL, RuntimeEnvironment, ServiceExecutionRole, ApplicationConfiguration = NULL, CloudWatchLoggingOptions = NULL, Tags = NULL, ApplicationMode = NULL) {
  op <- new_operation(
    name = "CreateApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$create_application_input(ApplicationName = ApplicationName, ApplicationDescription = ApplicationDescription, RuntimeEnvironment = RuntimeEnvironment, ServiceExecutionRole = ServiceExecutionRole, ApplicationConfiguration = ApplicationConfiguration, CloudWatchLoggingOptions = CloudWatchLoggingOptions, Tags = Tags, ApplicationMode = ApplicationMode)
  output <- .kinesisanalyticsv2$create_application_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$create_application <- kinesisanalyticsv2_create_application

#' Creates and returns a URL that you can use to connect to an
#' application's extension
#'
#' @description
#' Creates and returns a URL that you can use to connect to an application's extension.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_create_application_presigned_url/](https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_create_application_presigned_url/) for full documentation.
#'
#' @param ApplicationName &#91;required&#93; The name of the application.
#' @param UrlType &#91;required&#93; The type of the extension for which to create and return a URL.
#' Currently, the only valid extension URL type is `FLINK_DASHBOARD_URL`.
#' @param SessionExpirationDurationInSeconds The duration in seconds for which the returned URL will be valid.
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_create_application_presigned_url
kinesisanalyticsv2_create_application_presigned_url <- function(ApplicationName, UrlType, SessionExpirationDurationInSeconds = NULL) {
  op <- new_operation(
    name = "CreateApplicationPresignedUrl",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$create_application_presigned_url_input(ApplicationName = ApplicationName, UrlType = UrlType, SessionExpirationDurationInSeconds = SessionExpirationDurationInSeconds)
  output <- .kinesisanalyticsv2$create_application_presigned_url_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$create_application_presigned_url <- kinesisanalyticsv2_create_application_presigned_url

#' Creates a snapshot of the application's state data
#'
#' @description
#' Creates a snapshot of the application's state data.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_create_application_snapshot/](https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_create_application_snapshot/) for full documentation.
#'
#' @param ApplicationName &#91;required&#93; The name of an existing application
#' @param SnapshotName &#91;required&#93; An identifier for the application snapshot.
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_create_application_snapshot
kinesisanalyticsv2_create_application_snapshot <- function(ApplicationName, SnapshotName) {
  op <- new_operation(
    name = "CreateApplicationSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$create_application_snapshot_input(ApplicationName = ApplicationName, SnapshotName = SnapshotName)
  output <- .kinesisanalyticsv2$create_application_snapshot_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$create_application_snapshot <- kinesisanalyticsv2_create_application_snapshot

#' Deletes the specified application
#'
#' @description
#' Deletes the specified application. Managed Service for Apache Flink halts application execution and deletes the application.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_delete_application/](https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_delete_application/) for full documentation.
#'
#' @param ApplicationName &#91;required&#93; The name of the application to delete.
#' @param CreateTimestamp &#91;required&#93; Use the
#' [`describe_application`][kinesisanalyticsv2_describe_application]
#' operation to get this value.
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_delete_application
kinesisanalyticsv2_delete_application <- function(ApplicationName, CreateTimestamp) {
  op <- new_operation(
    name = "DeleteApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$delete_application_input(ApplicationName = ApplicationName, CreateTimestamp = CreateTimestamp)
  output <- .kinesisanalyticsv2$delete_application_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$delete_application <- kinesisanalyticsv2_delete_application

#' Deletes an Amazon CloudWatch log stream from an SQL-based Kinesis Data
#' Analytics application
#'
#' @description
#' Deletes an Amazon CloudWatch log stream from an SQL-based Kinesis Data Analytics application.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_delete_application_cloud_watch_logging_option/](https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_delete_application_cloud_watch_logging_option/) for full documentation.
#'
#' @param ApplicationName &#91;required&#93; The application name.
#' @param CurrentApplicationVersionId The version ID of the application. You must provide the
#' `CurrentApplicationVersionId` or the `ConditionalToken`. You can
#' retrieve the application version ID using
#' [`describe_application`][kinesisanalyticsv2_describe_application]. For
#' better concurrency support, use the `ConditionalToken` parameter instead
#' of `CurrentApplicationVersionId`.
#' @param CloudWatchLoggingOptionId &#91;required&#93; The `CloudWatchLoggingOptionId` of the Amazon CloudWatch logging option
#' to delete. You can get the `CloudWatchLoggingOptionId` by using the
#' [`describe_application`][kinesisanalyticsv2_describe_application]
#' operation.
#' @param ConditionalToken A value you use to implement strong concurrency for application updates.
#' You must provide the `CurrentApplicationVersionId` or the
#' `ConditionalToken`. You get the application's current `ConditionalToken`
#' using [`describe_application`][kinesisanalyticsv2_describe_application].
#' For better concurrency support, use the `ConditionalToken` parameter
#' instead of `CurrentApplicationVersionId`.
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_delet_appli_cloud_watch_loggi_optio
kinesisanalyticsv2_delete_application_cloud_watch_logging_option <- function(ApplicationName, CurrentApplicationVersionId = NULL, CloudWatchLoggingOptionId, ConditionalToken = NULL) {
  op <- new_operation(
    name = "DeleteApplicationCloudWatchLoggingOption",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$delete_application_cloud_watch_logging_option_input(ApplicationName = ApplicationName, CurrentApplicationVersionId = CurrentApplicationVersionId, CloudWatchLoggingOptionId = CloudWatchLoggingOptionId, ConditionalToken = ConditionalToken)
  output <- .kinesisanalyticsv2$delete_application_cloud_watch_logging_option_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$delete_application_cloud_watch_logging_option <- kinesisanalyticsv2_delete_application_cloud_watch_logging_option

#' Deletes an InputProcessingConfiguration from an input
#'
#' @description
#' Deletes an InputProcessingConfiguration from an input.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_delete_application_input_processing_configuration/](https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_delete_application_input_processing_configuration/) for full documentation.
#'
#' @param ApplicationName &#91;required&#93; The name of the application.
#' @param CurrentApplicationVersionId &#91;required&#93; The application version. You can use the
#' [`describe_application`][kinesisanalyticsv2_describe_application]
#' operation to get the current application version. If the version
#' specified is not the current version, the
#' `ConcurrentModificationException` is returned.
#' @param InputId &#91;required&#93; The ID of the input configuration from which to delete the input
#' processing configuration. You can get a list of the input IDs for an
#' application by using the
#' [`describe_application`][kinesisanalyticsv2_describe_application]
#' operation.
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_delete_applic_input_proces_config
kinesisanalyticsv2_delete_application_input_processing_configuration <- function(ApplicationName, CurrentApplicationVersionId, InputId) {
  op <- new_operation(
    name = "DeleteApplicationInputProcessingConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$delete_application_input_processing_configuration_input(ApplicationName = ApplicationName, CurrentApplicationVersionId = CurrentApplicationVersionId, InputId = InputId)
  output <- .kinesisanalyticsv2$delete_application_input_processing_configuration_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$delete_application_input_processing_configuration <- kinesisanalyticsv2_delete_application_input_processing_configuration

#' Deletes the output destination configuration from your SQL-based Kinesis
#' Data Analytics application's configuration
#'
#' @description
#' Deletes the output destination configuration from your SQL-based Kinesis Data Analytics application's configuration. Kinesis Data Analytics will no longer write data from the corresponding in-application stream to the external output destination.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_delete_application_output/](https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_delete_application_output/) for full documentation.
#'
#' @param ApplicationName &#91;required&#93; The application name.
#' @param CurrentApplicationVersionId &#91;required&#93; The application version. You can use the
#' [`describe_application`][kinesisanalyticsv2_describe_application]
#' operation to get the current application version. If the version
#' specified is not the current version, the
#' `ConcurrentModificationException` is returned.
#' @param OutputId &#91;required&#93; The ID of the configuration to delete. Each output configuration that is
#' added to the application (either when the application is created or
#' later) using the
#' [`add_application_output`][kinesisanalyticsv2_add_application_output]
#' operation has a unique ID. You need to provide the ID to uniquely
#' identify the output configuration that you want to delete from the
#' application configuration. You can use the
#' [`describe_application`][kinesisanalyticsv2_describe_application]
#' operation to get the specific `OutputId`.
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_delete_application_output
kinesisanalyticsv2_delete_application_output <- function(ApplicationName, CurrentApplicationVersionId, OutputId) {
  op <- new_operation(
    name = "DeleteApplicationOutput",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$delete_application_output_input(ApplicationName = ApplicationName, CurrentApplicationVersionId = CurrentApplicationVersionId, OutputId = OutputId)
  output <- .kinesisanalyticsv2$delete_application_output_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$delete_application_output <- kinesisanalyticsv2_delete_application_output

#' Deletes a reference data source configuration from the specified
#' SQL-based Kinesis Data Analytics application's configuration
#'
#' @description
#' Deletes a reference data source configuration from the specified SQL-based Kinesis Data Analytics application's configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_delete_application_reference_data_source/](https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_delete_application_reference_data_source/) for full documentation.
#'
#' @param ApplicationName &#91;required&#93; The name of an existing application.
#' @param CurrentApplicationVersionId &#91;required&#93; The current application version. You can use the
#' [`describe_application`][kinesisanalyticsv2_describe_application]
#' operation to get the current application version. If the version
#' specified is not the current version, the
#' `ConcurrentModificationException` is returned.
#' @param ReferenceId &#91;required&#93; The ID of the reference data source. When you add a reference data
#' source to your application using the
#' [`add_application_reference_data_source`][kinesisanalyticsv2_add_application_reference_data_source],
#' Kinesis Data Analytics assigns an ID. You can use the
#' [`describe_application`][kinesisanalyticsv2_describe_application]
#' operation to get the reference ID.
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_delete_application_reference_data_source
kinesisanalyticsv2_delete_application_reference_data_source <- function(ApplicationName, CurrentApplicationVersionId, ReferenceId) {
  op <- new_operation(
    name = "DeleteApplicationReferenceDataSource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$delete_application_reference_data_source_input(ApplicationName = ApplicationName, CurrentApplicationVersionId = CurrentApplicationVersionId, ReferenceId = ReferenceId)
  output <- .kinesisanalyticsv2$delete_application_reference_data_source_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$delete_application_reference_data_source <- kinesisanalyticsv2_delete_application_reference_data_source

#' Deletes a snapshot of application state
#'
#' @description
#' Deletes a snapshot of application state.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_delete_application_snapshot/](https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_delete_application_snapshot/) for full documentation.
#'
#' @param ApplicationName &#91;required&#93; The name of an existing application.
#' @param SnapshotName &#91;required&#93; The identifier for the snapshot delete.
#' @param SnapshotCreationTimestamp &#91;required&#93; The creation timestamp of the application snapshot to delete. You can
#' retrieve this value using or .
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_delete_application_snapshot
kinesisanalyticsv2_delete_application_snapshot <- function(ApplicationName, SnapshotName, SnapshotCreationTimestamp) {
  op <- new_operation(
    name = "DeleteApplicationSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$delete_application_snapshot_input(ApplicationName = ApplicationName, SnapshotName = SnapshotName, SnapshotCreationTimestamp = SnapshotCreationTimestamp)
  output <- .kinesisanalyticsv2$delete_application_snapshot_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$delete_application_snapshot <- kinesisanalyticsv2_delete_application_snapshot

#' Removes a VPC configuration from a Managed Service for Apache Flink
#' application
#'
#' @description
#' Removes a VPC configuration from a Managed Service for Apache Flink application.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_delete_application_vpc_configuration/](https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_delete_application_vpc_configuration/) for full documentation.
#'
#' @param ApplicationName &#91;required&#93; The name of an existing application.
#' @param CurrentApplicationVersionId The current application version ID. You must provide the
#' `CurrentApplicationVersionId` or the `ConditionalToken`. You can
#' retrieve the application version ID using
#' [`describe_application`][kinesisanalyticsv2_describe_application]. For
#' better concurrency support, use the `ConditionalToken` parameter instead
#' of `CurrentApplicationVersionId`.
#' @param VpcConfigurationId &#91;required&#93; The ID of the VPC configuration to delete.
#' @param ConditionalToken A value you use to implement strong concurrency for application updates.
#' You must provide the `CurrentApplicationVersionId` or the
#' `ConditionalToken`. You get the application's current `ConditionalToken`
#' using [`describe_application`][kinesisanalyticsv2_describe_application].
#' For better concurrency support, use the `ConditionalToken` parameter
#' instead of `CurrentApplicationVersionId`.
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_delete_application_vpc_configuration
kinesisanalyticsv2_delete_application_vpc_configuration <- function(ApplicationName, CurrentApplicationVersionId = NULL, VpcConfigurationId, ConditionalToken = NULL) {
  op <- new_operation(
    name = "DeleteApplicationVpcConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$delete_application_vpc_configuration_input(ApplicationName = ApplicationName, CurrentApplicationVersionId = CurrentApplicationVersionId, VpcConfigurationId = VpcConfigurationId, ConditionalToken = ConditionalToken)
  output <- .kinesisanalyticsv2$delete_application_vpc_configuration_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$delete_application_vpc_configuration <- kinesisanalyticsv2_delete_application_vpc_configuration

#' Returns information about a specific Managed Service for Apache Flink
#' application
#'
#' @description
#' Returns information about a specific Managed Service for Apache Flink application.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_describe_application/](https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_describe_application/) for full documentation.
#'
#' @param ApplicationName &#91;required&#93; The name of the application.
#' @param IncludeAdditionalDetails Displays verbose information about a Managed Service for Apache Flink
#' application, including the application's job plan.
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_describe_application
kinesisanalyticsv2_describe_application <- function(ApplicationName, IncludeAdditionalDetails = NULL) {
  op <- new_operation(
    name = "DescribeApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$describe_application_input(ApplicationName = ApplicationName, IncludeAdditionalDetails = IncludeAdditionalDetails)
  output <- .kinesisanalyticsv2$describe_application_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$describe_application <- kinesisanalyticsv2_describe_application

#' Returns information about a snapshot of application state data
#'
#' @description
#' Returns information about a snapshot of application state data.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_describe_application_snapshot/](https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_describe_application_snapshot/) for full documentation.
#'
#' @param ApplicationName &#91;required&#93; The name of an existing application.
#' @param SnapshotName &#91;required&#93; The identifier of an application snapshot. You can retrieve this value
#' using .
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_describe_application_snapshot
kinesisanalyticsv2_describe_application_snapshot <- function(ApplicationName, SnapshotName) {
  op <- new_operation(
    name = "DescribeApplicationSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$describe_application_snapshot_input(ApplicationName = ApplicationName, SnapshotName = SnapshotName)
  output <- .kinesisanalyticsv2$describe_application_snapshot_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$describe_application_snapshot <- kinesisanalyticsv2_describe_application_snapshot

#' Provides a detailed description of a specified version of the
#' application
#'
#' @description
#' Provides a detailed description of a specified version of the application. To see a list of all the versions of an application, invoke the [`list_application_versions`][kinesisanalyticsv2_list_application_versions] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_describe_application_version/](https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_describe_application_version/) for full documentation.
#'
#' @param ApplicationName &#91;required&#93; The name of the application for which you want to get the version
#' description.
#' @param ApplicationVersionId &#91;required&#93; The ID of the application version for which you want to get the
#' description.
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_describe_application_version
kinesisanalyticsv2_describe_application_version <- function(ApplicationName, ApplicationVersionId) {
  op <- new_operation(
    name = "DescribeApplicationVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$describe_application_version_input(ApplicationName = ApplicationName, ApplicationVersionId = ApplicationVersionId)
  output <- .kinesisanalyticsv2$describe_application_version_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$describe_application_version <- kinesisanalyticsv2_describe_application_version

#' Infers a schema for a SQL-based Kinesis Data Analytics application by
#' evaluating sample records on the specified streaming source (Kinesis
#' data stream or Kinesis Data Firehose delivery stream) or Amazon S3
#' object
#'
#' @description
#' Infers a schema for a SQL-based Kinesis Data Analytics application by evaluating sample records on the specified streaming source (Kinesis data stream or Kinesis Data Firehose delivery stream) or Amazon S3 object. In the response, the operation returns the inferred schema and also the sample records that the operation used to infer the schema.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_discover_input_schema/](https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_discover_input_schema/) for full documentation.
#'
#' @param ResourceARN The Amazon Resource Name (ARN) of the streaming source.
#' @param ServiceExecutionRole &#91;required&#93; The ARN of the role that is used to access the streaming source.
#' @param InputStartingPositionConfiguration The point at which you want Kinesis Data Analytics to start reading
#' records from the specified streaming source for discovery purposes.
#' @param S3Configuration Specify this parameter to discover a schema from data in an Amazon S3
#' object.
#' @param InputProcessingConfiguration The InputProcessingConfiguration to use to preprocess the records before
#' discovering the schema of the records.
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_discover_input_schema
kinesisanalyticsv2_discover_input_schema <- function(ResourceARN = NULL, ServiceExecutionRole, InputStartingPositionConfiguration = NULL, S3Configuration = NULL, InputProcessingConfiguration = NULL) {
  op <- new_operation(
    name = "DiscoverInputSchema",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$discover_input_schema_input(ResourceARN = ResourceARN, ServiceExecutionRole = ServiceExecutionRole, InputStartingPositionConfiguration = InputStartingPositionConfiguration, S3Configuration = S3Configuration, InputProcessingConfiguration = InputProcessingConfiguration)
  output <- .kinesisanalyticsv2$discover_input_schema_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$discover_input_schema <- kinesisanalyticsv2_discover_input_schema

#' Lists information about the current application snapshots
#'
#' @description
#' Lists information about the current application snapshots.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_list_application_snapshots/](https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_list_application_snapshots/) for full documentation.
#'
#' @param ApplicationName &#91;required&#93; The name of an existing application.
#' @param Limit The maximum number of application snapshots to list.
#' @param NextToken Use this parameter if you receive a `NextToken` response in a previous
#' request that indicates that there is more output available. Set it to
#' the value of the previous call's `NextToken` response to indicate where
#' the output should continue from.
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_list_application_snapshots
kinesisanalyticsv2_list_application_snapshots <- function(ApplicationName, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListApplicationSnapshots",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$list_application_snapshots_input(ApplicationName = ApplicationName, Limit = Limit, NextToken = NextToken)
  output <- .kinesisanalyticsv2$list_application_snapshots_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$list_application_snapshots <- kinesisanalyticsv2_list_application_snapshots

#' Lists all the versions for the specified application, including versions
#' that were rolled back
#'
#' @description
#' Lists all the versions for the specified application, including versions that were rolled back. The response also includes a summary of the configuration associated with each version.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_list_application_versions/](https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_list_application_versions/) for full documentation.
#'
#' @param ApplicationName &#91;required&#93; The name of the application for which you want to list all versions.
#' @param Limit The maximum number of versions to list in this invocation of the
#' operation.
#' @param NextToken If a previous invocation of this operation returned a pagination token,
#' pass it into this value to retrieve the next set of results. For more
#' information about pagination, see [Using the Amazon Command Line
#' Interface's Pagination
#' Options](https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-pagination.html).
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_list_application_versions
kinesisanalyticsv2_list_application_versions <- function(ApplicationName, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListApplicationVersions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$list_application_versions_input(ApplicationName = ApplicationName, Limit = Limit, NextToken = NextToken)
  output <- .kinesisanalyticsv2$list_application_versions_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$list_application_versions <- kinesisanalyticsv2_list_application_versions

#' Returns a list of Managed Service for Apache Flink applications in your
#' account
#'
#' @description
#' Returns a list of Managed Service for Apache Flink applications in your account. For each application, the response includes the application name, Amazon Resource Name (ARN), and status.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_list_applications/](https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_list_applications/) for full documentation.
#'
#' @param Limit The maximum number of applications to list.
#' @param NextToken If a previous command returned a pagination token, pass it into this
#' value to retrieve the next set of results. For more information about
#' pagination, see [Using the Amazon Command Line Interface's Pagination
#' Options](https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-pagination.html).
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_list_applications
kinesisanalyticsv2_list_applications <- function(Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListApplications",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$list_applications_input(Limit = Limit, NextToken = NextToken)
  output <- .kinesisanalyticsv2$list_applications_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$list_applications <- kinesisanalyticsv2_list_applications

#' Retrieves the list of key-value tags assigned to the application
#'
#' @description
#' Retrieves the list of key-value tags assigned to the application. For more information, see [Using Tagging](https://docs.aws.amazon.com/managed-flink/latest/java/how-tagging.html).
#'
#' See [https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The ARN of the application for which to retrieve tags.
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_list_tags_for_resource
kinesisanalyticsv2_list_tags_for_resource <- function(ResourceARN) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$list_tags_for_resource_input(ResourceARN = ResourceARN)
  output <- .kinesisanalyticsv2$list_tags_for_resource_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$list_tags_for_resource <- kinesisanalyticsv2_list_tags_for_resource

#' Reverts the application to the previous running version
#'
#' @description
#' Reverts the application to the previous running version. You can roll back an application if you suspect it is stuck in a transient status.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_rollback_application/](https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_rollback_application/) for full documentation.
#'
#' @param ApplicationName &#91;required&#93; The name of the application.
#' @param CurrentApplicationVersionId &#91;required&#93; The current application version ID. You can retrieve the application
#' version ID using
#' [`describe_application`][kinesisanalyticsv2_describe_application].
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_rollback_application
kinesisanalyticsv2_rollback_application <- function(ApplicationName, CurrentApplicationVersionId) {
  op <- new_operation(
    name = "RollbackApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$rollback_application_input(ApplicationName = ApplicationName, CurrentApplicationVersionId = CurrentApplicationVersionId)
  output <- .kinesisanalyticsv2$rollback_application_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$rollback_application <- kinesisanalyticsv2_rollback_application

#' Starts the specified Managed Service for Apache Flink application
#'
#' @description
#' Starts the specified Managed Service for Apache Flink application. After creating an application, you must exclusively call this operation to start your application.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_start_application/](https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_start_application/) for full documentation.
#'
#' @param ApplicationName &#91;required&#93; The name of the application.
#' @param RunConfiguration Identifies the run configuration (start parameters) of a Managed Service
#' for Apache Flink application.
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_start_application
kinesisanalyticsv2_start_application <- function(ApplicationName, RunConfiguration = NULL) {
  op <- new_operation(
    name = "StartApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$start_application_input(ApplicationName = ApplicationName, RunConfiguration = RunConfiguration)
  output <- .kinesisanalyticsv2$start_application_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$start_application <- kinesisanalyticsv2_start_application

#' Stops the application from processing data
#'
#' @description
#' Stops the application from processing data. You can stop an application only if it is in the running status, unless you set the `Force` parameter to `true`.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_stop_application/](https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_stop_application/) for full documentation.
#'
#' @param ApplicationName &#91;required&#93; The name of the running application to stop.
#' @param Force Set to `true` to force the application to stop. If you set `Force` to
#' `true`, Managed Service for Apache Flink stops the application without
#' taking a snapshot.
#' 
#' Force-stopping your application may lead to data loss or duplication. To
#' prevent data loss or duplicate processing of data during application
#' restarts, we recommend you to take frequent snapshots of your
#' application.
#' 
#' You can only force stop a Managed Service for Apache Flink application.
#' You can't force stop a SQL-based Kinesis Data Analytics application.
#' 
#' The application must be in the `STARTING`, `UPDATING`, `STOPPING`,
#' `AUTOSCALING`, or `RUNNING` status.
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_stop_application
kinesisanalyticsv2_stop_application <- function(ApplicationName, Force = NULL) {
  op <- new_operation(
    name = "StopApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$stop_application_input(ApplicationName = ApplicationName, Force = Force)
  output <- .kinesisanalyticsv2$stop_application_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$stop_application <- kinesisanalyticsv2_stop_application

#' Adds one or more key-value tags to a Managed Service for Apache Flink
#' application
#'
#' @description
#' Adds one or more key-value tags to a Managed Service for Apache Flink application. Note that the maximum number of application tags includes system tags. The maximum number of user-defined application tags is 50. For more information, see [Using Tagging](https://docs.aws.amazon.com/managed-flink/latest/java/how-tagging.html).
#'
#' See [https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_tag_resource/](https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_tag_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The ARN of the application to assign the tags.
#' @param Tags &#91;required&#93; The key-value tags to assign to the application.
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_tag_resource
kinesisanalyticsv2_tag_resource <- function(ResourceARN, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$tag_resource_input(ResourceARN = ResourceARN, Tags = Tags)
  output <- .kinesisanalyticsv2$tag_resource_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$tag_resource <- kinesisanalyticsv2_tag_resource

#' Removes one or more tags from a Managed Service for Apache Flink
#' application
#'
#' @description
#' Removes one or more tags from a Managed Service for Apache Flink application. For more information, see [Using Tagging](https://docs.aws.amazon.com/managed-flink/latest/java/how-tagging.html).
#'
#' See [https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_untag_resource/](https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_untag_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The ARN of the Managed Service for Apache Flink application from which
#' to remove the tags.
#' @param TagKeys &#91;required&#93; A list of keys of tags to remove from the specified application.
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_untag_resource
kinesisanalyticsv2_untag_resource <- function(ResourceARN, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$untag_resource_input(ResourceARN = ResourceARN, TagKeys = TagKeys)
  output <- .kinesisanalyticsv2$untag_resource_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$untag_resource <- kinesisanalyticsv2_untag_resource

#' Updates an existing Managed Service for Apache Flink application
#'
#' @description
#' Updates an existing Managed Service for Apache Flink application. Using this operation, you can update application code, input configuration, and output configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_update_application/](https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_update_application/) for full documentation.
#'
#' @param ApplicationName &#91;required&#93; The name of the application to update.
#' @param CurrentApplicationVersionId The current application version ID. You must provide the
#' `CurrentApplicationVersionId` or the `ConditionalToken`.You can retrieve
#' the application version ID using
#' [`describe_application`][kinesisanalyticsv2_describe_application]. For
#' better concurrency support, use the `ConditionalToken` parameter instead
#' of `CurrentApplicationVersionId`.
#' @param ApplicationConfigurationUpdate Describes application configuration updates.
#' @param ServiceExecutionRoleUpdate Describes updates to the service execution role.
#' @param RunConfigurationUpdate Describes updates to the application's starting parameters.
#' @param CloudWatchLoggingOptionUpdates Describes application Amazon CloudWatch logging option updates. You can
#' only update existing CloudWatch logging options with this action. To add
#' a new CloudWatch logging option, use
#' [`add_application_cloud_watch_logging_option`][kinesisanalyticsv2_add_application_cloud_watch_logging_option].
#' @param ConditionalToken A value you use to implement strong concurrency for application updates.
#' You must provide the `CurrentApplicationVersionId` or the
#' `ConditionalToken`. You get the application's current `ConditionalToken`
#' using [`describe_application`][kinesisanalyticsv2_describe_application].
#' For better concurrency support, use the `ConditionalToken` parameter
#' instead of `CurrentApplicationVersionId`.
#' @param RuntimeEnvironmentUpdate Updates the Managed Service for Apache Flink runtime environment used to
#' run your code. To avoid issues you must:
#' 
#' -   Ensure your new jar and dependencies are compatible with the new
#'     runtime selected.
#' 
#' -   Ensure your new code's state is compatible with the snapshot from
#'     which your application will start
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_update_application
kinesisanalyticsv2_update_application <- function(ApplicationName, CurrentApplicationVersionId = NULL, ApplicationConfigurationUpdate = NULL, ServiceExecutionRoleUpdate = NULL, RunConfigurationUpdate = NULL, CloudWatchLoggingOptionUpdates = NULL, ConditionalToken = NULL, RuntimeEnvironmentUpdate = NULL) {
  op <- new_operation(
    name = "UpdateApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$update_application_input(ApplicationName = ApplicationName, CurrentApplicationVersionId = CurrentApplicationVersionId, ApplicationConfigurationUpdate = ApplicationConfigurationUpdate, ServiceExecutionRoleUpdate = ServiceExecutionRoleUpdate, RunConfigurationUpdate = RunConfigurationUpdate, CloudWatchLoggingOptionUpdates = CloudWatchLoggingOptionUpdates, ConditionalToken = ConditionalToken, RuntimeEnvironmentUpdate = RuntimeEnvironmentUpdate)
  output <- .kinesisanalyticsv2$update_application_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$update_application <- kinesisanalyticsv2_update_application

#' Updates the maintenance configuration of the Managed Service for Apache
#' Flink application
#'
#' @description
#' Updates the maintenance configuration of the Managed Service for Apache Flink application.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_update_application_maintenance_configuration/](https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_update_application_maintenance_configuration/) for full documentation.
#'
#' @param ApplicationName &#91;required&#93; The name of the application for which you want to update the maintenance
#' configuration.
#' @param ApplicationMaintenanceConfigurationUpdate &#91;required&#93; Describes the application maintenance configuration update.
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_update_applic_mainte_config
kinesisanalyticsv2_update_application_maintenance_configuration <- function(ApplicationName, ApplicationMaintenanceConfigurationUpdate) {
  op <- new_operation(
    name = "UpdateApplicationMaintenanceConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$update_application_maintenance_configuration_input(ApplicationName = ApplicationName, ApplicationMaintenanceConfigurationUpdate = ApplicationMaintenanceConfigurationUpdate)
  output <- .kinesisanalyticsv2$update_application_maintenance_configuration_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$update_application_maintenance_configuration <- kinesisanalyticsv2_update_application_maintenance_configuration
