# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include entityresolution_service.R
NULL

#' Creates an IdMappingWorkflow object which stores the configuration of
#' the data processing job to be run
#'
#' @description
#' Creates an `IdMappingWorkflow` object which stores the configuration of the data processing job to be run. Each `IdMappingWorkflow` must have a unique workflow name. To modify an existing workflow, use the [`update_id_mapping_workflow`][entityresolution_update_id_mapping_workflow] API.
#'
#' See [https://www.paws-r-sdk.com/docs/entityresolution_create_id_mapping_workflow/](https://www.paws-r-sdk.com/docs/entityresolution_create_id_mapping_workflow/) for full documentation.
#'
#' @param description A description of the workflow.
#' @param idMappingTechniques &#91;required&#93; An object which defines the `idMappingType` and the
#' `providerProperties`.
#' @param inputSourceConfig &#91;required&#93; A list of `InputSource` objects, which have the fields `InputSourceARN`
#' and `SchemaName`.
#' @param outputSourceConfig &#91;required&#93; A list of `IdMappingWorkflowOutputSource` objects, each of which
#' contains fields `OutputS3Path` and `Output`.
#' @param roleArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role. Entity Resolution
#' assumes this role to create resources on your behalf as part of workflow
#' execution.
#' @param tags The tags used to organize, track, or control access for this resource.
#' @param workflowName &#91;required&#93; The name of the workflow. There can't be multiple `IdMappingWorkflows`
#' with the same name.
#'
#' @keywords internal
#'
#' @rdname entityresolution_create_id_mapping_workflow
entityresolution_create_id_mapping_workflow <- function(description = NULL, idMappingTechniques, inputSourceConfig, outputSourceConfig, roleArn, tags = NULL, workflowName) {
  op <- new_operation(
    name = "CreateIdMappingWorkflow",
    http_method = "POST",
    http_path = "/idmappingworkflows",
    paginator = list()
  )
  input <- .entityresolution$create_id_mapping_workflow_input(description = description, idMappingTechniques = idMappingTechniques, inputSourceConfig = inputSourceConfig, outputSourceConfig = outputSourceConfig, roleArn = roleArn, tags = tags, workflowName = workflowName)
  output <- .entityresolution$create_id_mapping_workflow_output()
  config <- get_config()
  svc <- .entityresolution$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.entityresolution$operations$create_id_mapping_workflow <- entityresolution_create_id_mapping_workflow

#' Creates a MatchingWorkflow object which stores the configuration of the
#' data processing job to be run
#'
#' @description
#' Creates a `MatchingWorkflow` object which stores the configuration of the data processing job to be run. It is important to note that there should not be a pre-existing `MatchingWorkflow` with the same name. To modify an existing workflow, utilize the [`update_matching_workflow`][entityresolution_update_matching_workflow] API.
#'
#' See [https://www.paws-r-sdk.com/docs/entityresolution_create_matching_workflow/](https://www.paws-r-sdk.com/docs/entityresolution_create_matching_workflow/) for full documentation.
#'
#' @param description A description of the workflow.
#' @param incrementalRunConfig An object which defines an incremental run type and has only
#' `incrementalRunType` as a field.
#' @param inputSourceConfig &#91;required&#93; A list of `InputSource` objects, which have the fields `InputSourceARN`
#' and `SchemaName`.
#' @param outputSourceConfig &#91;required&#93; A list of `OutputSource` objects, each of which contains fields
#' `OutputS3Path`, `ApplyNormalization`, and `Output`.
#' @param resolutionTechniques &#91;required&#93; An object which defines the `resolutionType` and the
#' `ruleBasedProperties`.
#' @param roleArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role. Entity Resolution
#' assumes this role to create resources on your behalf as part of workflow
#' execution.
#' @param tags The tags used to organize, track, or control access for this resource.
#' @param workflowName &#91;required&#93; The name of the workflow. There can't be multiple `MatchingWorkflows`
#' with the same name.
#'
#' @keywords internal
#'
#' @rdname entityresolution_create_matching_workflow
entityresolution_create_matching_workflow <- function(description = NULL, incrementalRunConfig = NULL, inputSourceConfig, outputSourceConfig, resolutionTechniques, roleArn, tags = NULL, workflowName) {
  op <- new_operation(
    name = "CreateMatchingWorkflow",
    http_method = "POST",
    http_path = "/matchingworkflows",
    paginator = list()
  )
  input <- .entityresolution$create_matching_workflow_input(description = description, incrementalRunConfig = incrementalRunConfig, inputSourceConfig = inputSourceConfig, outputSourceConfig = outputSourceConfig, resolutionTechniques = resolutionTechniques, roleArn = roleArn, tags = tags, workflowName = workflowName)
  output <- .entityresolution$create_matching_workflow_output()
  config <- get_config()
  svc <- .entityresolution$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.entityresolution$operations$create_matching_workflow <- entityresolution_create_matching_workflow

#' Creates a schema mapping, which defines the schema of the input customer
#' records table
#'
#' @description
#' Creates a schema mapping, which defines the schema of the input customer records table. The `SchemaMapping` also provides Entity Resolution with some metadata about the table, such as the attribute types of the columns and which columns to match on.
#'
#' See [https://www.paws-r-sdk.com/docs/entityresolution_create_schema_mapping/](https://www.paws-r-sdk.com/docs/entityresolution_create_schema_mapping/) for full documentation.
#'
#' @param description A description of the schema.
#' @param mappedInputFields &#91;required&#93; A list of `MappedInputFields`. Each `MappedInputField` corresponds to a
#' column the source data table, and contains column name plus additional
#' information that Entity Resolution uses for matching.
#' @param schemaName &#91;required&#93; The name of the schema. There can't be multiple `SchemaMappings` with
#' the same name.
#' @param tags The tags used to organize, track, or control access for this resource.
#'
#' @keywords internal
#'
#' @rdname entityresolution_create_schema_mapping
entityresolution_create_schema_mapping <- function(description = NULL, mappedInputFields, schemaName, tags = NULL) {
  op <- new_operation(
    name = "CreateSchemaMapping",
    http_method = "POST",
    http_path = "/schemas",
    paginator = list()
  )
  input <- .entityresolution$create_schema_mapping_input(description = description, mappedInputFields = mappedInputFields, schemaName = schemaName, tags = tags)
  output <- .entityresolution$create_schema_mapping_output()
  config <- get_config()
  svc <- .entityresolution$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.entityresolution$operations$create_schema_mapping <- entityresolution_create_schema_mapping

#' Deletes the IdMappingWorkflow with a given name
#'
#' @description
#' Deletes the `IdMappingWorkflow` with a given name. This operation will succeed even if a workflow with the given name does not exist.
#'
#' See [https://www.paws-r-sdk.com/docs/entityresolution_delete_id_mapping_workflow/](https://www.paws-r-sdk.com/docs/entityresolution_delete_id_mapping_workflow/) for full documentation.
#'
#' @param workflowName &#91;required&#93; The name of the workflow to be deleted.
#'
#' @keywords internal
#'
#' @rdname entityresolution_delete_id_mapping_workflow
entityresolution_delete_id_mapping_workflow <- function(workflowName) {
  op <- new_operation(
    name = "DeleteIdMappingWorkflow",
    http_method = "DELETE",
    http_path = "/idmappingworkflows/{workflowName}",
    paginator = list()
  )
  input <- .entityresolution$delete_id_mapping_workflow_input(workflowName = workflowName)
  output <- .entityresolution$delete_id_mapping_workflow_output()
  config <- get_config()
  svc <- .entityresolution$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.entityresolution$operations$delete_id_mapping_workflow <- entityresolution_delete_id_mapping_workflow

#' Deletes the MatchingWorkflow with a given name
#'
#' @description
#' Deletes the `MatchingWorkflow` with a given name. This operation will succeed even if a workflow with the given name does not exist.
#'
#' See [https://www.paws-r-sdk.com/docs/entityresolution_delete_matching_workflow/](https://www.paws-r-sdk.com/docs/entityresolution_delete_matching_workflow/) for full documentation.
#'
#' @param workflowName &#91;required&#93; The name of the workflow to be retrieved.
#'
#' @keywords internal
#'
#' @rdname entityresolution_delete_matching_workflow
entityresolution_delete_matching_workflow <- function(workflowName) {
  op <- new_operation(
    name = "DeleteMatchingWorkflow",
    http_method = "DELETE",
    http_path = "/matchingworkflows/{workflowName}",
    paginator = list()
  )
  input <- .entityresolution$delete_matching_workflow_input(workflowName = workflowName)
  output <- .entityresolution$delete_matching_workflow_output()
  config <- get_config()
  svc <- .entityresolution$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.entityresolution$operations$delete_matching_workflow <- entityresolution_delete_matching_workflow

#' Deletes the SchemaMapping with a given name
#'
#' @description
#' Deletes the `SchemaMapping` with a given name. This operation will succeed even if a schema with the given name does not exist. This operation will fail if there is a `MatchingWorkflow` object that references the `SchemaMapping` in the workflow's `InputSourceConfig`.
#'
#' See [https://www.paws-r-sdk.com/docs/entityresolution_delete_schema_mapping/](https://www.paws-r-sdk.com/docs/entityresolution_delete_schema_mapping/) for full documentation.
#'
#' @param schemaName &#91;required&#93; The name of the schema to delete.
#'
#' @keywords internal
#'
#' @rdname entityresolution_delete_schema_mapping
entityresolution_delete_schema_mapping <- function(schemaName) {
  op <- new_operation(
    name = "DeleteSchemaMapping",
    http_method = "DELETE",
    http_path = "/schemas/{schemaName}",
    paginator = list()
  )
  input <- .entityresolution$delete_schema_mapping_input(schemaName = schemaName)
  output <- .entityresolution$delete_schema_mapping_output()
  config <- get_config()
  svc <- .entityresolution$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.entityresolution$operations$delete_schema_mapping <- entityresolution_delete_schema_mapping

#' Gets the status, metrics, and errors (if there are any) that are
#' associated with a job
#'
#' @description
#' Gets the status, metrics, and errors (if there are any) that are associated with a job.
#'
#' See [https://www.paws-r-sdk.com/docs/entityresolution_get_id_mapping_job/](https://www.paws-r-sdk.com/docs/entityresolution_get_id_mapping_job/) for full documentation.
#'
#' @param jobId &#91;required&#93; The ID of the job.
#' @param workflowName &#91;required&#93; The name of the workflow.
#'
#' @keywords internal
#'
#' @rdname entityresolution_get_id_mapping_job
entityresolution_get_id_mapping_job <- function(jobId, workflowName) {
  op <- new_operation(
    name = "GetIdMappingJob",
    http_method = "GET",
    http_path = "/idmappingworkflows/{workflowName}/jobs/{jobId}",
    paginator = list()
  )
  input <- .entityresolution$get_id_mapping_job_input(jobId = jobId, workflowName = workflowName)
  output <- .entityresolution$get_id_mapping_job_output()
  config <- get_config()
  svc <- .entityresolution$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.entityresolution$operations$get_id_mapping_job <- entityresolution_get_id_mapping_job

#' Returns the IdMappingWorkflow with a given name, if it exists
#'
#' @description
#' Returns the `IdMappingWorkflow` with a given name, if it exists.
#'
#' See [https://www.paws-r-sdk.com/docs/entityresolution_get_id_mapping_workflow/](https://www.paws-r-sdk.com/docs/entityresolution_get_id_mapping_workflow/) for full documentation.
#'
#' @param workflowName &#91;required&#93; The name of the workflow.
#'
#' @keywords internal
#'
#' @rdname entityresolution_get_id_mapping_workflow
entityresolution_get_id_mapping_workflow <- function(workflowName) {
  op <- new_operation(
    name = "GetIdMappingWorkflow",
    http_method = "GET",
    http_path = "/idmappingworkflows/{workflowName}",
    paginator = list()
  )
  input <- .entityresolution$get_id_mapping_workflow_input(workflowName = workflowName)
  output <- .entityresolution$get_id_mapping_workflow_output()
  config <- get_config()
  svc <- .entityresolution$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.entityresolution$operations$get_id_mapping_workflow <- entityresolution_get_id_mapping_workflow

#' Returns the corresponding Match ID of a customer record if the record
#' has been processed
#'
#' @description
#' Returns the corresponding Match ID of a customer record if the record has been processed.
#'
#' See [https://www.paws-r-sdk.com/docs/entityresolution_get_match_id/](https://www.paws-r-sdk.com/docs/entityresolution_get_match_id/) for full documentation.
#'
#' @param record &#91;required&#93; The record to fetch the Match ID for.
#' @param workflowName &#91;required&#93; The name of the workflow.
#'
#' @keywords internal
#'
#' @rdname entityresolution_get_match_id
entityresolution_get_match_id <- function(record, workflowName) {
  op <- new_operation(
    name = "GetMatchId",
    http_method = "POST",
    http_path = "/matchingworkflows/{workflowName}/matches",
    paginator = list()
  )
  input <- .entityresolution$get_match_id_input(record = record, workflowName = workflowName)
  output <- .entityresolution$get_match_id_output()
  config <- get_config()
  svc <- .entityresolution$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.entityresolution$operations$get_match_id <- entityresolution_get_match_id

#' Gets the status, metrics, and errors (if there are any) that are
#' associated with a job
#'
#' @description
#' Gets the status, metrics, and errors (if there are any) that are associated with a job.
#'
#' See [https://www.paws-r-sdk.com/docs/entityresolution_get_matching_job/](https://www.paws-r-sdk.com/docs/entityresolution_get_matching_job/) for full documentation.
#'
#' @param jobId &#91;required&#93; The ID of the job.
#' @param workflowName &#91;required&#93; The name of the workflow.
#'
#' @keywords internal
#'
#' @rdname entityresolution_get_matching_job
entityresolution_get_matching_job <- function(jobId, workflowName) {
  op <- new_operation(
    name = "GetMatchingJob",
    http_method = "GET",
    http_path = "/matchingworkflows/{workflowName}/jobs/{jobId}",
    paginator = list()
  )
  input <- .entityresolution$get_matching_job_input(jobId = jobId, workflowName = workflowName)
  output <- .entityresolution$get_matching_job_output()
  config <- get_config()
  svc <- .entityresolution$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.entityresolution$operations$get_matching_job <- entityresolution_get_matching_job

#' Returns the MatchingWorkflow with a given name, if it exists
#'
#' @description
#' Returns the `MatchingWorkflow` with a given name, if it exists.
#'
#' See [https://www.paws-r-sdk.com/docs/entityresolution_get_matching_workflow/](https://www.paws-r-sdk.com/docs/entityresolution_get_matching_workflow/) for full documentation.
#'
#' @param workflowName &#91;required&#93; The name of the workflow.
#'
#' @keywords internal
#'
#' @rdname entityresolution_get_matching_workflow
entityresolution_get_matching_workflow <- function(workflowName) {
  op <- new_operation(
    name = "GetMatchingWorkflow",
    http_method = "GET",
    http_path = "/matchingworkflows/{workflowName}",
    paginator = list()
  )
  input <- .entityresolution$get_matching_workflow_input(workflowName = workflowName)
  output <- .entityresolution$get_matching_workflow_output()
  config <- get_config()
  svc <- .entityresolution$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.entityresolution$operations$get_matching_workflow <- entityresolution_get_matching_workflow

#' Returns the ProviderService of a given name
#'
#' @description
#' Returns the `ProviderService` of a given name.
#'
#' See [https://www.paws-r-sdk.com/docs/entityresolution_get_provider_service/](https://www.paws-r-sdk.com/docs/entityresolution_get_provider_service/) for full documentation.
#'
#' @param providerName &#91;required&#93; The name of the provider. This name is typically the company name.
#' @param providerServiceName &#91;required&#93; The ARN (Amazon Resource Name) of the product that the provider service
#' provides.
#'
#' @keywords internal
#'
#' @rdname entityresolution_get_provider_service
entityresolution_get_provider_service <- function(providerName, providerServiceName) {
  op <- new_operation(
    name = "GetProviderService",
    http_method = "GET",
    http_path = "/providerservices/{providerName}/{providerServiceName}",
    paginator = list()
  )
  input <- .entityresolution$get_provider_service_input(providerName = providerName, providerServiceName = providerServiceName)
  output <- .entityresolution$get_provider_service_output()
  config <- get_config()
  svc <- .entityresolution$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.entityresolution$operations$get_provider_service <- entityresolution_get_provider_service

#' Returns the SchemaMapping of a given name
#'
#' @description
#' Returns the SchemaMapping of a given name.
#'
#' See [https://www.paws-r-sdk.com/docs/entityresolution_get_schema_mapping/](https://www.paws-r-sdk.com/docs/entityresolution_get_schema_mapping/) for full documentation.
#'
#' @param schemaName &#91;required&#93; The name of the schema to be retrieved.
#'
#' @keywords internal
#'
#' @rdname entityresolution_get_schema_mapping
entityresolution_get_schema_mapping <- function(schemaName) {
  op <- new_operation(
    name = "GetSchemaMapping",
    http_method = "GET",
    http_path = "/schemas/{schemaName}",
    paginator = list()
  )
  input <- .entityresolution$get_schema_mapping_input(schemaName = schemaName)
  output <- .entityresolution$get_schema_mapping_output()
  config <- get_config()
  svc <- .entityresolution$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.entityresolution$operations$get_schema_mapping <- entityresolution_get_schema_mapping

#' Lists all ID mapping jobs for a given workflow
#'
#' @description
#' Lists all ID mapping jobs for a given workflow.
#'
#' See [https://www.paws-r-sdk.com/docs/entityresolution_list_id_mapping_jobs/](https://www.paws-r-sdk.com/docs/entityresolution_list_id_mapping_jobs/) for full documentation.
#'
#' @param maxResults The maximum number of objects returned per page.
#' @param nextToken The pagination token from the previous API call.
#' @param workflowName &#91;required&#93; The name of the workflow to be retrieved.
#'
#' @keywords internal
#'
#' @rdname entityresolution_list_id_mapping_jobs
entityresolution_list_id_mapping_jobs <- function(maxResults = NULL, nextToken = NULL, workflowName) {
  op <- new_operation(
    name = "ListIdMappingJobs",
    http_method = "GET",
    http_path = "/idmappingworkflows/{workflowName}/jobs",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "jobs")
  )
  input <- .entityresolution$list_id_mapping_jobs_input(maxResults = maxResults, nextToken = nextToken, workflowName = workflowName)
  output <- .entityresolution$list_id_mapping_jobs_output()
  config <- get_config()
  svc <- .entityresolution$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.entityresolution$operations$list_id_mapping_jobs <- entityresolution_list_id_mapping_jobs

#' Returns a list of all the IdMappingWorkflows that have been created for
#' an Amazon Web Services account
#'
#' @description
#' Returns a list of all the `IdMappingWorkflows` that have been created for an Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/entityresolution_list_id_mapping_workflows/](https://www.paws-r-sdk.com/docs/entityresolution_list_id_mapping_workflows/) for full documentation.
#'
#' @param maxResults The maximum number of objects returned per page.
#' @param nextToken The pagination token from the previous API call.
#'
#' @keywords internal
#'
#' @rdname entityresolution_list_id_mapping_workflows
entityresolution_list_id_mapping_workflows <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListIdMappingWorkflows",
    http_method = "GET",
    http_path = "/idmappingworkflows",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "workflowSummaries")
  )
  input <- .entityresolution$list_id_mapping_workflows_input(maxResults = maxResults, nextToken = nextToken)
  output <- .entityresolution$list_id_mapping_workflows_output()
  config <- get_config()
  svc <- .entityresolution$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.entityresolution$operations$list_id_mapping_workflows <- entityresolution_list_id_mapping_workflows

#' Lists all jobs for a given workflow
#'
#' @description
#' Lists all jobs for a given workflow.
#'
#' See [https://www.paws-r-sdk.com/docs/entityresolution_list_matching_jobs/](https://www.paws-r-sdk.com/docs/entityresolution_list_matching_jobs/) for full documentation.
#'
#' @param maxResults The maximum number of objects returned per page.
#' @param nextToken The pagination token from the previous API call.
#' @param workflowName &#91;required&#93; The name of the workflow to be retrieved.
#'
#' @keywords internal
#'
#' @rdname entityresolution_list_matching_jobs
entityresolution_list_matching_jobs <- function(maxResults = NULL, nextToken = NULL, workflowName) {
  op <- new_operation(
    name = "ListMatchingJobs",
    http_method = "GET",
    http_path = "/matchingworkflows/{workflowName}/jobs",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "jobs")
  )
  input <- .entityresolution$list_matching_jobs_input(maxResults = maxResults, nextToken = nextToken, workflowName = workflowName)
  output <- .entityresolution$list_matching_jobs_output()
  config <- get_config()
  svc <- .entityresolution$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.entityresolution$operations$list_matching_jobs <- entityresolution_list_matching_jobs

#' Returns a list of all the MatchingWorkflows that have been created for
#' an Amazon Web Services account
#'
#' @description
#' Returns a list of all the `MatchingWorkflows` that have been created for an Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/entityresolution_list_matching_workflows/](https://www.paws-r-sdk.com/docs/entityresolution_list_matching_workflows/) for full documentation.
#'
#' @param maxResults The maximum number of objects returned per page.
#' @param nextToken The pagination token from the previous API call.
#'
#' @keywords internal
#'
#' @rdname entityresolution_list_matching_workflows
entityresolution_list_matching_workflows <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListMatchingWorkflows",
    http_method = "GET",
    http_path = "/matchingworkflows",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "workflowSummaries")
  )
  input <- .entityresolution$list_matching_workflows_input(maxResults = maxResults, nextToken = nextToken)
  output <- .entityresolution$list_matching_workflows_output()
  config <- get_config()
  svc <- .entityresolution$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.entityresolution$operations$list_matching_workflows <- entityresolution_list_matching_workflows

#' Returns a list of all the ProviderServices that are available in this
#' Amazon Web Services Region
#'
#' @description
#' Returns a list of all the `ProviderServices` that are available in this Amazon Web Services Region.
#'
#' See [https://www.paws-r-sdk.com/docs/entityresolution_list_provider_services/](https://www.paws-r-sdk.com/docs/entityresolution_list_provider_services/) for full documentation.
#'
#' @param maxResults The maximum number of objects returned per page.
#' @param nextToken The pagination token from the previous API call.
#' @param providerName The name of the provider. This name is typically the company name.
#'
#' @keywords internal
#'
#' @rdname entityresolution_list_provider_services
entityresolution_list_provider_services <- function(maxResults = NULL, nextToken = NULL, providerName = NULL) {
  op <- new_operation(
    name = "ListProviderServices",
    http_method = "GET",
    http_path = "/providerservices",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "providerServiceSummaries")
  )
  input <- .entityresolution$list_provider_services_input(maxResults = maxResults, nextToken = nextToken, providerName = providerName)
  output <- .entityresolution$list_provider_services_output()
  config <- get_config()
  svc <- .entityresolution$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.entityresolution$operations$list_provider_services <- entityresolution_list_provider_services

#' Returns a list of all the SchemaMappings that have been created for an
#' Amazon Web Services account
#'
#' @description
#' Returns a list of all the `SchemaMappings` that have been created for an Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/entityresolution_list_schema_mappings/](https://www.paws-r-sdk.com/docs/entityresolution_list_schema_mappings/) for full documentation.
#'
#' @param maxResults The maximum number of objects returned per page.
#' @param nextToken The pagination token from the previous API call.
#'
#' @keywords internal
#'
#' @rdname entityresolution_list_schema_mappings
entityresolution_list_schema_mappings <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListSchemaMappings",
    http_method = "GET",
    http_path = "/schemas",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "schemaList")
  )
  input <- .entityresolution$list_schema_mappings_input(maxResults = maxResults, nextToken = nextToken)
  output <- .entityresolution$list_schema_mappings_output()
  config <- get_config()
  svc <- .entityresolution$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.entityresolution$operations$list_schema_mappings <- entityresolution_list_schema_mappings

#' Displays the tags associated with an Entity Resolution resource
#'
#' @description
#' Displays the tags associated with an Entity Resolution resource. In Entity Resolution, `SchemaMapping`, and `MatchingWorkflow` can be tagged.
#'
#' See [https://www.paws-r-sdk.com/docs/entityresolution_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/entityresolution_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the resource for which you want to view tags.
#'
#' @keywords internal
#'
#' @rdname entityresolution_list_tags_for_resource
entityresolution_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .entityresolution$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .entityresolution$list_tags_for_resource_output()
  config <- get_config()
  svc <- .entityresolution$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.entityresolution$operations$list_tags_for_resource <- entityresolution_list_tags_for_resource

#' Starts the IdMappingJob of a workflow
#'
#' @description
#' Starts the `IdMappingJob` of a workflow. The workflow must have previously been created using the [`create_id_mapping_workflow`][entityresolution_create_id_mapping_workflow] endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/entityresolution_start_id_mapping_job/](https://www.paws-r-sdk.com/docs/entityresolution_start_id_mapping_job/) for full documentation.
#'
#' @param workflowName &#91;required&#93; The name of the ID mapping job to be retrieved.
#'
#' @keywords internal
#'
#' @rdname entityresolution_start_id_mapping_job
entityresolution_start_id_mapping_job <- function(workflowName) {
  op <- new_operation(
    name = "StartIdMappingJob",
    http_method = "POST",
    http_path = "/idmappingworkflows/{workflowName}/jobs",
    paginator = list()
  )
  input <- .entityresolution$start_id_mapping_job_input(workflowName = workflowName)
  output <- .entityresolution$start_id_mapping_job_output()
  config <- get_config()
  svc <- .entityresolution$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.entityresolution$operations$start_id_mapping_job <- entityresolution_start_id_mapping_job

#' Starts the MatchingJob of a workflow
#'
#' @description
#' Starts the `MatchingJob` of a workflow. The workflow must have previously been created using the [`create_matching_workflow`][entityresolution_create_matching_workflow] endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/entityresolution_start_matching_job/](https://www.paws-r-sdk.com/docs/entityresolution_start_matching_job/) for full documentation.
#'
#' @param workflowName &#91;required&#93; The name of the matching job to be retrieved.
#'
#' @keywords internal
#'
#' @rdname entityresolution_start_matching_job
entityresolution_start_matching_job <- function(workflowName) {
  op <- new_operation(
    name = "StartMatchingJob",
    http_method = "POST",
    http_path = "/matchingworkflows/{workflowName}/jobs",
    paginator = list()
  )
  input <- .entityresolution$start_matching_job_input(workflowName = workflowName)
  output <- .entityresolution$start_matching_job_output()
  config <- get_config()
  svc <- .entityresolution$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.entityresolution$operations$start_matching_job <- entityresolution_start_matching_job

#' Assigns one or more tags (key-value pairs) to the specified Entity
#' Resolution resource
#'
#' @description
#' Assigns one or more tags (key-value pairs) to the specified Entity Resolution resource. Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values. In Entity Resolution, `SchemaMapping` and `MatchingWorkflow` can be tagged. Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters. You can use the [`tag_resource`][entityresolution_tag_resource] action with a resource that already has tags. If you specify a new tag key, this tag is appended to the list of tags associated with the resource. If you specify a tag key that is already associated with the resource, the new tag value that you specify replaces the previous value for that tag.
#'
#' See [https://www.paws-r-sdk.com/docs/entityresolution_tag_resource/](https://www.paws-r-sdk.com/docs/entityresolution_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the resource for which you want to view tags.
#' @param tags &#91;required&#93; The tags used to organize, track, or control access for this resource.
#'
#' @keywords internal
#'
#' @rdname entityresolution_tag_resource
entityresolution_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .entityresolution$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .entityresolution$tag_resource_output()
  config <- get_config()
  svc <- .entityresolution$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.entityresolution$operations$tag_resource <- entityresolution_tag_resource

#' Removes one or more tags from the specified Entity Resolution resource
#'
#' @description
#' Removes one or more tags from the specified Entity Resolution resource. In Entity Resolution, `SchemaMapping`, and `MatchingWorkflow` can be tagged.
#'
#' See [https://www.paws-r-sdk.com/docs/entityresolution_untag_resource/](https://www.paws-r-sdk.com/docs/entityresolution_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the resource for which you want to untag.
#' @param tagKeys &#91;required&#93; The list of tag keys to remove from the resource.
#'
#' @keywords internal
#'
#' @rdname entityresolution_untag_resource
entityresolution_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .entityresolution$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .entityresolution$untag_resource_output()
  config <- get_config()
  svc <- .entityresolution$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.entityresolution$operations$untag_resource <- entityresolution_untag_resource

#' Updates an existing IdMappingWorkflow
#'
#' @description
#' Updates an existing `IdMappingWorkflow`. This method is identical to [`create_id_mapping_workflow`][entityresolution_create_id_mapping_workflow], except it uses an HTTP `PUT` request instead of a `POST` request, and the `IdMappingWorkflow` must already exist for the method to succeed.
#'
#' See [https://www.paws-r-sdk.com/docs/entityresolution_update_id_mapping_workflow/](https://www.paws-r-sdk.com/docs/entityresolution_update_id_mapping_workflow/) for full documentation.
#'
#' @param description A description of the workflow.
#' @param idMappingTechniques &#91;required&#93; An object which defines the `idMappingType` and the
#' `providerProperties`.
#' @param inputSourceConfig &#91;required&#93; A list of `InputSource` objects, which have the fields `InputSourceARN`
#' and `SchemaName`.
#' @param outputSourceConfig &#91;required&#93; A list of `OutputSource` objects, each of which contains fields
#' `OutputS3Path` and `KMSArn`.
#' @param roleArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role. Entity Resolution
#' assumes this role to access resources on your behalf.
#' @param workflowName &#91;required&#93; The name of the workflow.
#'
#' @keywords internal
#'
#' @rdname entityresolution_update_id_mapping_workflow
entityresolution_update_id_mapping_workflow <- function(description = NULL, idMappingTechniques, inputSourceConfig, outputSourceConfig, roleArn, workflowName) {
  op <- new_operation(
    name = "UpdateIdMappingWorkflow",
    http_method = "PUT",
    http_path = "/idmappingworkflows/{workflowName}",
    paginator = list()
  )
  input <- .entityresolution$update_id_mapping_workflow_input(description = description, idMappingTechniques = idMappingTechniques, inputSourceConfig = inputSourceConfig, outputSourceConfig = outputSourceConfig, roleArn = roleArn, workflowName = workflowName)
  output <- .entityresolution$update_id_mapping_workflow_output()
  config <- get_config()
  svc <- .entityresolution$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.entityresolution$operations$update_id_mapping_workflow <- entityresolution_update_id_mapping_workflow

#' Updates an existing MatchingWorkflow
#'
#' @description
#' Updates an existing `MatchingWorkflow`. This method is identical to [`create_matching_workflow`][entityresolution_create_matching_workflow], except it uses an HTTP `PUT` request instead of a `POST` request, and the `MatchingWorkflow` must already exist for the method to succeed.
#'
#' See [https://www.paws-r-sdk.com/docs/entityresolution_update_matching_workflow/](https://www.paws-r-sdk.com/docs/entityresolution_update_matching_workflow/) for full documentation.
#'
#' @param description A description of the workflow.
#' @param incrementalRunConfig An object which defines an incremental run type and has only
#' `incrementalRunType` as a field.
#' @param inputSourceConfig &#91;required&#93; A list of `InputSource` objects, which have the fields `InputSourceARN`
#' and `SchemaName`.
#' @param outputSourceConfig &#91;required&#93; A list of `OutputSource` objects, each of which contains fields
#' `OutputS3Path`, `ApplyNormalization`, and `Output`.
#' @param resolutionTechniques &#91;required&#93; An object which defines the `resolutionType` and the
#' `ruleBasedProperties`.
#' @param roleArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role. Entity Resolution
#' assumes this role to create resources on your behalf as part of workflow
#' execution.
#' @param workflowName &#91;required&#93; The name of the workflow to be retrieved.
#'
#' @keywords internal
#'
#' @rdname entityresolution_update_matching_workflow
entityresolution_update_matching_workflow <- function(description = NULL, incrementalRunConfig = NULL, inputSourceConfig, outputSourceConfig, resolutionTechniques, roleArn, workflowName) {
  op <- new_operation(
    name = "UpdateMatchingWorkflow",
    http_method = "PUT",
    http_path = "/matchingworkflows/{workflowName}",
    paginator = list()
  )
  input <- .entityresolution$update_matching_workflow_input(description = description, incrementalRunConfig = incrementalRunConfig, inputSourceConfig = inputSourceConfig, outputSourceConfig = outputSourceConfig, resolutionTechniques = resolutionTechniques, roleArn = roleArn, workflowName = workflowName)
  output <- .entityresolution$update_matching_workflow_output()
  config <- get_config()
  svc <- .entityresolution$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.entityresolution$operations$update_matching_workflow <- entityresolution_update_matching_workflow

#' Updates a schema mapping
#'
#' @description
#' Updates a schema mapping.
#'
#' See [https://www.paws-r-sdk.com/docs/entityresolution_update_schema_mapping/](https://www.paws-r-sdk.com/docs/entityresolution_update_schema_mapping/) for full documentation.
#'
#' @param description A description of the schema.
#' @param mappedInputFields &#91;required&#93; A list of `MappedInputFields`. Each `MappedInputField` corresponds to a
#' column the source data table, and contains column name plus additional
#' information that Entity Resolution uses for matching.
#' @param schemaName &#91;required&#93; The name of the schema. There can't be multiple `SchemaMappings` with
#' the same name.
#'
#' @keywords internal
#'
#' @rdname entityresolution_update_schema_mapping
entityresolution_update_schema_mapping <- function(description = NULL, mappedInputFields, schemaName) {
  op <- new_operation(
    name = "UpdateSchemaMapping",
    http_method = "PUT",
    http_path = "/schemas/{schemaName}",
    paginator = list()
  )
  input <- .entityresolution$update_schema_mapping_input(description = description, mappedInputFields = mappedInputFields, schemaName = schemaName)
  output <- .entityresolution$update_schema_mapping_output()
  config <- get_config()
  svc <- .entityresolution$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.entityresolution$operations$update_schema_mapping <- entityresolution_update_schema_mapping
