% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emr_operations.R
\name{emr_update_studio}
\alias{emr_update_studio}
\title{Updates an Amazon EMR Studio configuration, including attributes such as
name, description, and subnets}
\usage{
emr_update_studio(
  StudioId,
  Name = NULL,
  Description = NULL,
  SubnetIds = NULL,
  DefaultS3Location = NULL
)
}
\arguments{
\item{StudioId}{[required] The ID of the Amazon EMR Studio to update.}

\item{Name}{A descriptive name for the Amazon EMR Studio.}

\item{Description}{A detailed description to assign to the Amazon EMR Studio.}

\item{SubnetIds}{A list of subnet IDs to associate with the Amazon EMR Studio. The list
can include new subnet IDs, but must also include all of the subnet IDs
previously associated with the Studio. The list order does not matter. A
Studio can have a maximum of 5 subnets. The subnets must belong to the
same VPC as the Studio.}

\item{DefaultS3Location}{The Amazon S3 location to back up Workspaces and notebook files for the
Amazon EMR Studio.}
}
\description{
Updates an Amazon EMR Studio configuration, including attributes such as name, description, and subnets.

See \url{https://www.paws-r-sdk.com/docs/emr_update_studio/} for full documentation.
}
\keyword{internal}
