% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_describe_account_customization}
\alias{quicksight_describe_account_customization}
\title{Describes the customizations associated with the provided Amazon Web
Services account and Amazon Amazon QuickSight namespace in an Amazon Web
Services Region}
\usage{
quicksight_describe_account_customization(
  AwsAccountId,
  Namespace = NULL,
  Resolved = NULL
)
}
\arguments{
\item{AwsAccountId}{[required] The ID for the Amazon Web Services account that you want to describe
Amazon QuickSight customizations for.}

\item{Namespace}{The Amazon QuickSight namespace that you want to describe Amazon
QuickSight customizations for.}

\item{Resolved}{The \code{Resolved} flag works with the other parameters to determine which
view of Amazon QuickSight customizations is returned. You can add this
flag to your command to use the same view that Amazon QuickSight uses to
identify which customizations to apply to the console. Omit this flag,
or set it to \code{no-resolved}, to reveal customizations that are configured
at different levels.}
}
\description{
Describes the customizations associated with the provided Amazon Web Services account and Amazon Amazon QuickSight namespace in an Amazon Web Services Region. The Amazon QuickSight console evaluates which customizations to apply by running this API operation with the \code{Resolved} flag included.

See \url{https://paws-r.github.io/docs/quicksight/describe_account_customization.html} for full documentation.
}
\keyword{internal}
