% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_create_iam_policy_assignment}
\alias{quicksight_create_iam_policy_assignment}
\title{Creates an assignment with one specified IAM policy, identified by its
Amazon Resource Name (ARN)}
\usage{
quicksight_create_iam_policy_assignment(
  AwsAccountId,
  AssignmentName,
  AssignmentStatus,
  PolicyArn = NULL,
  Identities = NULL,
  Namespace
)
}
\arguments{
\item{AwsAccountId}{[required] The ID of the Amazon Web Services account where you want to assign an
IAM policy to Amazon QuickSight users or groups.}

\item{AssignmentName}{[required] The name of the assignment, also called a rule. It must be unique within
an Amazon Web Services account.}

\item{AssignmentStatus}{[required] The status of the assignment. Possible values are as follows:
\itemize{
\item \code{ENABLED} - Anything specified in this assignment is used when
creating the data source.
\item \code{DISABLED} - This assignment isn't used when creating the data
source.
\item \code{DRAFT} - This assignment is an unfinished draft and isn't used when
creating the data source.
}}

\item{PolicyArn}{The ARN for the IAM policy to apply to the Amazon QuickSight users and
groups specified in this assignment.}

\item{Identities}{The Amazon QuickSight users, groups, or both that you want to assign the
policy to.}

\item{Namespace}{[required] The namespace that contains the assignment.}
}
\description{
Creates an assignment with one specified IAM policy, identified by its Amazon Resource Name (ARN). This policy assignment is attached to the specified groups or users of Amazon QuickSight. Assignment names are unique per Amazon Web Services account. To avoid overwriting rules in other namespaces, use assignment names that are unique.

See \url{https://paws-r.github.io/docs/quicksight/create_iam_policy_assignment.html} for full documentation.
}
\keyword{internal}
