% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kendra_operations.R
\name{kendra_list_groups_older_than_ordering_id}
\alias{kendra_list_groups_older_than_ordering_id}
\title{Provides a list of groups that are mapped to users before a given
ordering or timestamp identifier}
\usage{
kendra_list_groups_older_than_ordering_id(
  IndexId,
  DataSourceId = NULL,
  OrderingId,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{IndexId}{[required] The identifier of the index for getting a list of groups mapped to users
before a given ordering or timestamp identifier.}

\item{DataSourceId}{The identifier of the data source for getting a list of groups mapped to
users before a given ordering timestamp identifier.}

\item{OrderingId}{[required] The timestamp identifier used for the latest \code{PUT} or \code{DELETE} action
for mapping users to their groups.}

\item{NextToken}{If the previous response was incomplete (because there is more data to
retrieve), Amazon Kendra returns a pagination token in the response. You
can use this pagination token to retrieve the next set of groups that
are mapped to users before a given ordering or timestamp identifier.}

\item{MaxResults}{The maximum number of returned groups that are mapped to users before a
given ordering or timestamp identifier.}
}
\description{
Provides a list of groups that are mapped to users before a given ordering or timestamp identifier.

See \url{https://paws-r.github.io/docs/kendra/list_groups_older_than_ordering_id.html} for full documentation.
}
\keyword{internal}
