% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_create_custom_entity_type}
\alias{glue_create_custom_entity_type}
\title{Creates a custom pattern that is used to detect sensitive data across
the columns and rows of your structured data}
\usage{
glue_create_custom_entity_type(Name, RegexString, ContextWords = NULL)
}
\arguments{
\item{Name}{[required] A name for the custom pattern that allows it to be retrieved or deleted
later. This name must be unique per Amazon Web Services account.}

\item{RegexString}{[required] A regular expression string that is used for detecting sensitive data in
a custom pattern.}

\item{ContextWords}{A list of context words. If none of these context words are found within
the vicinity of the regular expression the data will not be detected as
sensitive data.

If no context words are passed only a regular expression is checked.}
}
\description{
Creates a custom pattern that is used to detect sensitive data across the columns and rows of your structured data.

See \url{https://paws-r.github.io/docs/glue/create_custom_entity_type.html} for full documentation.
}
\keyword{internal}
