% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/firehose_operations.R
\name{firehose_delete_delivery_stream}
\alias{firehose_delete_delivery_stream}
\title{Deletes a delivery stream and its data}
\usage{
firehose_delete_delivery_stream(DeliveryStreamName, AllowForceDelete = NULL)
}
\arguments{
\item{DeliveryStreamName}{[required] The name of the delivery stream.}

\item{AllowForceDelete}{Set this to true if you want to delete the delivery stream even if
Kinesis Data Firehose is unable to retire the grant for the CMK. Kinesis
Data Firehose might be unable to retire the grant due to a customer
error, such as when the CMK or the grant are in an invalid state. If you
force deletion, you can then use the
\href{https://docs.aws.amazon.com/kms/latest/APIReference/API_RevokeGrant.html}{RevokeGrant}
operation to revoke the grant you gave to Kinesis Data Firehose. If a
failure to retire the grant happens due to an AWS KMS issue, Kinesis
Data Firehose keeps retrying the delete operation.

The default value is false.}
}
\description{
Deletes a delivery stream and its data.

See \url{https://paws-r.github.io/docs/firehose/delete_delivery_stream.html} for full documentation.
}
\keyword{internal}
