% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emr_operations.R
\name{emr_add_job_flow_steps}
\alias{emr_add_job_flow_steps}
\title{AddJobFlowSteps adds new steps to a running cluster}
\usage{
emr_add_job_flow_steps(JobFlowId, Steps, ExecutionRoleArn = NULL)
}
\arguments{
\item{JobFlowId}{[required] A string that uniquely identifies the job flow. This identifier is
returned by \code{\link[=emr_run_job_flow]{run_job_flow}} and can also be obtained
from \code{\link[=emr_list_clusters]{list_clusters}}.}

\item{Steps}{[required] A list of StepConfig to be executed by the job flow.}

\item{ExecutionRoleArn}{The Amazon Resource Name (ARN) of the runtime role for a step on the
cluster. The runtime role can be a cross-account IAM role. The runtime
role ARN is a combination of account ID, role name, and role type using
the following format: \code{arn:partition:service:region:account:resource}.

For example, \verb{arn:aws:iam::1234567890:role/ReadOnly} is a correctly
formatted runtime role ARN.}
}
\description{
AddJobFlowSteps adds new steps to a running cluster. A maximum of 256 steps are allowed in each job flow.

See \url{https://paws-r.github.io/docs/emr/add_job_flow_steps.html} for full documentation.
}
\keyword{internal}
