% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kafka_operations.R
\name{kafka_update_cluster_kafka_version}
\alias{kafka_update_cluster_kafka_version}
\title{Updates the Apache Kafka version for the cluster}
\usage{
kafka_update_cluster_kafka_version(ClusterArn, ConfigurationInfo,
  CurrentVersion, TargetKafkaVersion)
}
\arguments{
\item{ClusterArn}{[required] The Amazon Resource Name (ARN) of the cluster to be updated.}

\item{ConfigurationInfo}{The custom configuration that should be applied on the new version of
cluster.}

\item{CurrentVersion}{[required] Current cluster version.}

\item{TargetKafkaVersion}{[required] Target Kafka version.}
}
\value{
A list with the following syntax:\preformatted{list(
  ClusterArn = "string",
  ClusterOperationArn = "string"
)
}
}
\description{
Updates the Apache Kafka version for the cluster.
}
\section{Request syntax}{
\preformatted{svc$update_cluster_kafka_version(
  ClusterArn = "string",
  ConfigurationInfo = list(
    Arn = "string",
    Revision = 123
  ),
  CurrentVersion = "string",
  TargetKafkaVersion = "string"
)
}
}

\keyword{internal}
