% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mturk_operations.R
\name{mturk_create_additional_assignments_for_hit}
\alias{mturk_create_additional_assignments_for_hit}
\title{The CreateAdditionalAssignmentsForHIT operation increases the maximum
number of assignments of an existing HIT}
\usage{
mturk_create_additional_assignments_for_hit(HITId,
  NumberOfAdditionalAssignments, UniqueRequestToken)
}
\arguments{
\item{HITId}{[required] The ID of the HIT to extend.}

\item{NumberOfAdditionalAssignments}{[required] The number of additional assignments to request for this HIT.}

\item{UniqueRequestToken}{A unique identifier for this request, which allows you to retry the call
on error without extending the HIT multiple times. This is useful in
cases such as network timeouts where it is unclear whether or not the
call succeeded on the server. If the extend HIT already exists in the
system from a previous call using the same \code{UniqueRequestToken},
subsequent calls will return an error with a message containing the
request ID.}
}
\description{
The \code{CreateAdditionalAssignmentsForHIT} operation increases the maximum
number of assignments of an existing HIT.

To extend the maximum number of assignments, specify the number of
additional assignments.
\itemize{
\item HITs created with fewer than 10 assignments cannot be extended to
have 10 or more assignments. Attempting to add assignments in a way
that brings the total number of assignments for a HIT from fewer
than 10 assignments to 10 or more assignments will result in an
\code{AWS.MechanicalTurk.InvalidMaximumAssignmentsIncrease} exception.
\item HITs that were created before July 22, 2015 cannot be extended.
Attempting to extend HITs that were created before July 22, 2015
will result in an \code{AWS.MechanicalTurk.HITTooOldForExtension}
exception.
}
}
\section{Request syntax}{
\preformatted{svc$create_additional_assignments_for_hit(
  HITId = "string",
  NumberOfAdditionalAssignments = 123,
  UniqueRequestToken = "string"
)
}
}

\keyword{internal}
